/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DruidClient;
import com.facebook.presto.druid.DruidSplit;
import com.facebook.presto.druid.DruidTableHandle;
import com.facebook.presto.druid.DruidTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class DruidSplitManager
implements ConnectorSplitManager {
    private final DruidClient druidClient;

    @Inject
    public DruidSplitManager(DruidClient druidClient) {
        this.druidClient = Objects.requireNonNull(druidClient, "druid client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        DruidTableLayoutHandle layoutHandle = (DruidTableLayoutHandle)layout;
        DruidTableHandle table = layoutHandle.getTable();
        if (table.getDql().isPresent() && table.getDql().get().getPushdown()) {
            return new FixedSplitSource((Iterable)ImmutableList.of((Object)DruidSplit.createBrokerSplit(table.getDql().get())));
        }
        List<String> segmentIds = this.druidClient.getDataSegmentId(table.getTableName());
        List splits = (List)segmentIds.stream().map(id -> this.druidClient.getSingleSegmentInfo(table.getTableName(), (String)id)).map(info -> DruidSplit.createSegmentSplit(info, HostAddress.fromUri((URI)this.druidClient.getDruidBroker()))).collect(ImmutableList.toImmutableList());
        return new FixedSplitSource((Iterable)splits);
    }
}

