/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DruidAggregationColumnNode;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.List;

public class DruidPushdownUtils {
    private DruidPushdownUtils() {
    }

    public static List<DruidAggregationColumnNode> computeAggregationNodes(AggregationNode aggregationNode) {
        int groupByKeyIndex = 0;
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        for (VariableReferenceExpression outputColumn : aggregationNode.getOutputVariables()) {
            AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)aggregationNode.getAggregations().get(outputColumn);
            if (aggregation != null) {
                if (aggregation.getFilter().isPresent() || aggregation.isDistinct() || aggregation.getOrderBy().isPresent() || aggregation.getMask().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported aggregation node " + aggregationNode);
                }
                nodeBuilder.add((Object)new DruidAggregationColumnNode.AggregationFunctionColumnNode(outputColumn, aggregation.getCall()));
                continue;
            }
            VariableReferenceExpression inputColumn = (VariableReferenceExpression)aggregationNode.getGroupingKeys().get(groupByKeyIndex);
            nodeBuilder.add((Object)new DruidAggregationColumnNode.GroupByColumnNode(inputColumn, outputColumn));
            ++groupByKeyIndex;
        }
        return nodeBuilder.build();
    }

    private static Number decodeDecimal(BigInteger unscaledValue, DecimalType type) {
        return new BigDecimal(unscaledValue, type.getScale(), new MathContext(type.getPrecision()));
    }

    public static String getLiteralAsString(ConstantExpression node) {
        Type type = node.getType();
        if (node.getValue() == null) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Null constant expression: " + node + " with value of type: " + type);
        }
        if (type instanceof BooleanType) {
            return String.valueOf((Boolean)node.getValue());
        }
        if (type instanceof BigintType || type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType) {
            Number number = (Number)node.getValue();
            return String.format("%d", number.longValue());
        }
        if (type instanceof DoubleType) {
            return node.getValue().toString();
        }
        if (type instanceof RealType) {
            Long number = (Long)node.getValue();
            return String.format("%f", Float.valueOf(Float.intBitsToFloat(number.intValue())));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                Preconditions.checkState((boolean)(node.getValue() instanceof Long));
                return DruidPushdownUtils.decodeDecimal(BigInteger.valueOf((Long)node.getValue()), decimalType).toString();
            }
            Preconditions.checkState((boolean)(node.getValue() instanceof Slice));
            Slice value = (Slice)node.getValue();
            return DruidPushdownUtils.decodeDecimal(Decimals.decodeUnscaledValue((Slice)value), decimalType).toString();
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return "'" + ((Slice)node.getValue()).toStringUtf8() + "'";
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Cannot handle the constant expression: " + node + " with value of type: " + type);
    }
}

