/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.DruidExpression;
import com.facebook.presto.druid.DruidQueryGeneratorContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class DruidProjectExpressionConverter
implements RowExpressionVisitor<DruidExpression, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection>> {
    private static final Set<String> TIME_EQUIVALENT_TYPES = ImmutableSet.of((Object)"bigint", (Object)"integer", (Object)"tinyint", (Object)"smallint");
    protected final TypeManager typeManager;
    protected final StandardFunctionResolution standardFunctionResolution;

    public DruidProjectExpressionConverter(TypeManager typeManager, StandardFunctionResolution standardFunctionResolution) {
        this.typeManager = Objects.requireNonNull(typeManager, "type manager");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standardFunctionResolution is null");
    }

    public DruidExpression visitVariableReference(VariableReferenceExpression reference, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        DruidQueryGeneratorContext.Selection input = Objects.requireNonNull(context.get(reference), String.format("Input column %s does not exist in the input", reference));
        return new DruidExpression(input.getDefinition(), input.getOrigin());
    }

    public DruidExpression visitLambda(LambdaDefinitionExpression lambda, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Druid does not support lambda: " + lambda);
    }

    protected boolean isImplicitCast(Type inputType, Type resultType) {
        if (this.typeManager.canCoerce(inputType, resultType)) {
            return true;
        }
        return resultType.getTypeSignature().getBase().equals("timestamp") && TIME_EQUIVALENT_TYPES.contains(inputType.getTypeSignature().getBase());
    }

    private DruidExpression handleCast(CallExpression cast, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        if (cast.getArguments().size() == 1) {
            RowExpression input = (RowExpression)cast.getArguments().get(0);
            Type expectedType = cast.getType();
            if (this.isImplicitCast(input.getType(), expectedType)) {
                return (DruidExpression)input.accept((RowExpressionVisitor)this, context);
            }
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Non implicit casts not supported: " + cast);
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "This type of CAST operator not supported: " + cast);
    }

    protected Optional<DruidExpression> basicCallHandling(CallExpression call, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        FunctionHandle functionHandle = call.getFunctionHandle();
        if (this.standardFunctionResolution.isNotFunction(functionHandle) || this.standardFunctionResolution.isBetweenFunction(functionHandle)) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported function in Druid aggregation: " + functionHandle);
        }
        if (this.standardFunctionResolution.isCastFunction(functionHandle)) {
            return Optional.of(this.handleCast(call, context));
        }
        return Optional.empty();
    }

    public DruidExpression visitInputReference(InputReferenceExpression reference, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Input reference not supported: " + reference);
    }

    public DruidExpression visitSpecialForm(SpecialFormExpression specialForm, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Special form not supported: " + specialForm);
    }

    public DruidExpression visitCall(CallExpression call, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        return this.basicCallHandling(call, context).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Call not supported: " + call));
    }

    public DruidExpression visitConstant(ConstantExpression literal, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Constant not supported: " + literal);
    }
}

