/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DruidClient;
import com.facebook.presto.druid.DruidColumnHandle;
import com.facebook.presto.druid.DruidTableHandle;
import com.facebook.presto.druid.DruidTableLayoutHandle;
import com.facebook.presto.druid.metadata.DruidColumnInfo;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class DruidMetadata
implements ConnectorMetadata {
    private final DruidClient druidClient;

    @Inject
    public DruidMetadata(DruidClient druidClient) {
        this.druidClient = Objects.requireNonNull(druidClient, "druidClient is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.druidClient.getSchemas();
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.druidClient.getTables().stream().filter(name -> name.equals(tableName.getTableName())).map(name -> DruidTableHandle.fromSchemaTableName(tableName)).findFirst().orElse(null);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        DruidTableHandle handle = (DruidTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new DruidTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DruidTableHandle druidTable = (DruidTableHandle)tableHandle;
        List columns = (List)this.druidClient.getColumnDataType(druidTable.getTableName()).stream().map(column -> DruidMetadata.toColumnMetadata(column)).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(druidTable.toSchemaTableName(), columns);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return (List)this.druidClient.getTables().stream().map(tableName -> new SchemaTableName(this.druidClient.getSchema(), tableName)).collect(ImmutableList.toImmutableList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DruidTableHandle druidTable = (DruidTableHandle)tableHandle;
        return (Map)this.druidClient.getColumnDataType(druidTable.getTableName()).stream().collect(ImmutableMap.toImmutableMap(DruidColumnInfo::getColumnName, column -> DruidMetadata.toColumnHandle(column)));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, DruidTableHandle.fromSchemaTableName(tableName));
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((DruidColumnHandle)columnHandle).getColumnMetadata();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTableName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }

    private static Type getType(String type) {
        switch (type.toUpperCase()) {
            case "VARCHAR": {
                return VarcharType.VARCHAR;
            }
            case "BIGINT": {
                return BigintType.BIGINT;
            }
            case "FLOAT": {
                return RealType.REAL;
            }
            case "DOUBLE": {
                return DoubleType.DOUBLE;
            }
            case "TIMESTAMP": {
                return TimestampType.TIMESTAMP;
            }
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static ColumnMetadata toColumnMetadata(DruidColumnInfo column) {
        return new ColumnMetadata(column.getColumnName(), DruidMetadata.getType(column.getDataType()));
    }

    private static ColumnHandle toColumnHandle(DruidColumnInfo column) {
        return new DruidColumnHandle(column.getColumnName(), DruidMetadata.getType(column.getDataType()));
    }
}

