/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.DruidExpression;
import com.facebook.presto.druid.DruidProjectExpressionConverter;
import com.facebook.presto.druid.DruidPushdownUtils;
import com.facebook.presto.druid.DruidQueryGeneratorContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTimeZone;

public class DruidAggregationProjectConverter
extends DruidProjectExpressionConverter {
    private static final Map<String, String> PRESTO_TO_DRUID_OPERATORS = ImmutableMap.of((Object)"-", (Object)"SUB", (Object)"+", (Object)"ADD", (Object)"*", (Object)"MULT", (Object)"/", (Object)"DIV");
    private static final String FROM_UNIXTIME = "from_unixtime";
    private static final String DATE_TRUNC = "date_trunc";
    private final FunctionMetadataManager functionMetadataManager;

    public DruidAggregationProjectConverter(TypeManager typeManager, FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution) {
        super(typeManager, standardFunctionResolution);
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
    }

    @Override
    public DruidExpression visitCall(CallExpression call, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        Optional<DruidExpression> basicCallHandlingResult = this.basicCallHandling(call, context);
        if (basicCallHandlingResult.isPresent()) {
            return basicCallHandlingResult.get();
        }
        FunctionMetadata functionMetadata = this.functionMetadataManager.getFunctionMetadata(call.getFunctionHandle());
        Optional operatorTypeOptional = functionMetadata.getOperatorType();
        if (operatorTypeOptional.isPresent()) {
            OperatorType operatorType = (OperatorType)operatorTypeOptional.get();
            if (operatorType.isArithmeticOperator()) {
                return this.handleArithmeticExpression(call, operatorType, context);
            }
            if (operatorType.isComparisonOperator()) {
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported operator: " + call + " to pushdown for Druid connector.");
            }
        }
        return this.handleFunction(call, context);
    }

    @Override
    public DruidExpression visitConstant(ConstantExpression literal, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        return new DruidExpression(DruidPushdownUtils.getLiteralAsString(literal), DruidQueryGeneratorContext.Origin.LITERAL);
    }

    private DruidExpression handleDateTruncationViaDateTruncation(CallExpression function, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        RowExpression timeInputParameter = (RowExpression)function.getArguments().get(1);
        CallExpression timeConversion = this.getExpressionAsFunction(timeInputParameter, timeInputParameter);
        if (!timeConversion.getDisplayName().toLowerCase(Locale.ENGLISH).equals(FROM_UNIXTIME)) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported time function: " + timeConversion.getDisplayName() + " to pushdown for Druid connector.");
        }
        String inputColumn = ((DruidExpression)((RowExpression)timeConversion.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition();
        String inputTimeZone = timeConversion.getArguments().size() > 1 ? DruidAggregationProjectConverter.getStringFromConstant((RowExpression)timeConversion.getArguments().get(1)) : DateTimeZone.UTC.getID();
        String inputFormat = "seconds";
        RowExpression intervalParameter = (RowExpression)function.getArguments().get(0);
        if (!(intervalParameter instanceof ConstantExpression)) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported interval unit: " + intervalParameter + " to pushdown for Druid connector.");
        }
        return DruidExpression.derived("dateTrunc(" + inputColumn + "," + inputFormat + ", " + inputTimeZone + ", " + DruidAggregationProjectConverter.getStringFromConstant(intervalParameter) + ")");
    }

    private DruidExpression handleArithmeticExpression(CallExpression expression, OperatorType operatorType, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        List arguments = expression.getArguments();
        if (arguments.size() == 1) {
            String prefix = operatorType == OperatorType.NEGATION ? "-" : "";
            return DruidExpression.derived(prefix + ((DruidExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, context)).getDefinition());
        }
        if (arguments.size() == 2) {
            DruidExpression left = (DruidExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, context);
            DruidExpression right = (DruidExpression)((RowExpression)arguments.get(1)).accept((RowExpressionVisitor)this, context);
            String prestoOperator = operatorType.getOperator();
            String druidOperator = PRESTO_TO_DRUID_OPERATORS.get(prestoOperator);
            if (druidOperator == null) {
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported binary expression: " + prestoOperator + " to pushdown for Druid connector.");
            }
            return DruidExpression.derived(String.format("%s(%s, %s)", druidOperator, left.getDefinition(), right.getDefinition()));
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported arithmetic expression: " + expression + " to pushdown for Druid connector.");
    }

    private DruidExpression handleFunction(CallExpression function, Map<VariableReferenceExpression, DruidQueryGeneratorContext.Selection> context) {
        if (function.getDisplayName().toLowerCase(Locale.ENGLISH).equals(DATE_TRUNC)) {
            return this.handleDateTruncationViaDateTruncation(function, context);
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Unsupported function: " + function.getDisplayName() + " to pushdown for Druid connector.");
    }

    private static String getStringFromConstant(RowExpression expression) {
        if (expression instanceof ConstantExpression) {
            Object value = ((ConstantExpression)expression).getValue();
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Slice) {
                return ((Slice)value).toStringUtf8();
            }
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Expected string literal but found: " + expression + " to pushdown for Druid connector.");
    }

    private CallExpression getExpressionAsFunction(RowExpression originalExpression, RowExpression expression) {
        if (expression instanceof CallExpression) {
            CallExpression call = (CallExpression)expression;
            if (this.standardFunctionResolution.isCastFunction(call.getFunctionHandle())) {
                if (this.isImplicitCast(((RowExpression)call.getArguments().get(0)).getType(), call.getType())) {
                    return this.getExpressionAsFunction(originalExpression, (RowExpression)call.getArguments().get(0));
                }
            } else {
                return call;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_PUSHDOWN_UNSUPPORTED_EXPRESSION, "Could not dig function out of expression: " + originalExpression + ", inside of: " + expression + " to pushdown for Druid connector.");
    }
}

