/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.column;

import com.facebook.presto.druid.column.ColumnReader;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.segment.ColumnValueSelector;

public class DoubleColumnReader
implements ColumnReader {
    private final ColumnValueSelector<Double> valueSelector;

    public DoubleColumnReader(ColumnValueSelector valueSelector) {
        this.valueSelector = Objects.requireNonNull(valueSelector, "value selector is null");
    }

    @Override
    public Block readBlock(Type type, int batchSize) {
        Preconditions.checkArgument((type == DoubleType.DOUBLE ? 1 : 0) != 0);
        BlockBuilder builder = type.createBlockBuilder(null, batchSize);
        for (int i = 0; i < batchSize; ++i) {
            type.writeDouble(builder, this.valueSelector.getDouble());
        }
        return builder.build();
    }
}

