/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DruidColumnHandle;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.DruidFilterExpressionConverter;
import com.facebook.presto.druid.DruidQueryGenerator;
import com.facebook.presto.druid.DruidQueryGeneratorContext;
import com.facebook.presto.druid.DruidTableHandle;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class DruidPlanOptimizer
implements ConnectorPlanOptimizer {
    private final DruidQueryGenerator druidQueryGenerator;
    private final TypeManager typeManager;
    private final FunctionMetadataManager functionMetadataManager;
    private final LogicalRowExpressions logicalRowExpressions;
    private final StandardFunctionResolution standardFunctionResolution;

    @Inject
    public DruidPlanOptimizer(DruidQueryGenerator druidQueryGenerator, TypeManager typeManager, DeterminismEvaluator determinismEvaluator, FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution) {
        this.druidQueryGenerator = Objects.requireNonNull(druidQueryGenerator, "pinot query generator is null");
        this.typeManager = Objects.requireNonNull(typeManager, "type manager is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "function manager is null");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standard function resolution is null");
        this.logicalRowExpressions = new LogicalRowExpressions(determinismEvaluator, standardFunctionResolution, functionMetadataManager);
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        Map scanNodes = (Map)maxSubplan.accept((PlanVisitor)new TableFindingVisitor(), null);
        TableScanNode druidTableScanNode = DruidPlanOptimizer.getOnlyDruidTable(scanNodes).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expected to find druid table handle for the scan node"));
        return (PlanNode)maxSubplan.accept((PlanVisitor)new Visitor(druidTableScanNode, session, idAllocator), null);
    }

    private static Optional<DruidTableHandle> getDruidTableHandle(TableScanNode tableScanNode) {
        ConnectorTableHandle connectorHandle;
        TableHandle table = tableScanNode.getTable();
        if (table != null && (connectorHandle = table.getConnectorHandle()) instanceof DruidTableHandle) {
            return Optional.of((DruidTableHandle)connectorHandle);
        }
        return Optional.empty();
    }

    private static Optional<TableScanNode> getOnlyDruidTable(Map<TableScanNode, Void> scanNodes) {
        TableScanNode tableScanNode;
        if (scanNodes.size() == 1 && DruidPlanOptimizer.getDruidTableHandle(tableScanNode = scanNodes.keySet().iterator().next()).isPresent()) {
            return Optional.of(tableScanNode);
        }
        return Optional.empty();
    }

    private static PlanNode replaceChildren(PlanNode node, List<PlanNode> children) {
        for (int i = 0; i < node.getSources().size(); ++i) {
            if (children.get(i) == node.getSources().get(i)) continue;
            return node.replaceChildren(children);
        }
        return node;
    }

    private class Visitor
    extends PlanVisitor<PlanNode, Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final ConnectorSession session;
        private final TableScanNode tableScanNode;
        private final IdentityHashMap<FilterNode, Void> filtersSplitUp = new IdentityHashMap();

        public Visitor(TableScanNode tableScanNode, ConnectorSession session, PlanNodeIdAllocator idAllocator) {
            this.session = session;
            this.idAllocator = idAllocator;
            this.tableScanNode = tableScanNode;
            ((DruidTableHandle)DruidPlanOptimizer.getDruidTableHandle(this.tableScanNode).get()).getTableName();
        }

        private Optional<PlanNode> tryCreatingNewScanNode(PlanNode plan) {
            Optional<DruidQueryGenerator.DruidQueryGeneratorResult> dql = DruidPlanOptimizer.this.druidQueryGenerator.generate(plan, this.session);
            if (!dql.isPresent()) {
                return Optional.empty();
            }
            DruidTableHandle druidTableHandle = (DruidTableHandle)DruidPlanOptimizer.getDruidTableHandle(this.tableScanNode).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_QUERY_GENERATOR_FAILURE, "Expected to find a druid table handle"));
            DruidQueryGeneratorContext context = dql.get().getContext();
            TableHandle oldTableHandle = this.tableScanNode.getTable();
            Map<VariableReferenceExpression, DruidColumnHandle> assignments = context.getAssignments();
            TableHandle newTableHandle = new TableHandle(oldTableHandle.getConnectorId(), (ConnectorTableHandle)new DruidTableHandle(druidTableHandle.getSchemaName(), druidTableHandle.getTableName(), Optional.of(dql.get().getGeneratedDql())), oldTableHandle.getTransaction(), oldTableHandle.getLayout());
            return Optional.of(new TableScanNode(this.idAllocator.getNextId(), newTableHandle, (List)ImmutableList.copyOf(assignments.keySet()), (Map)assignments.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> (ColumnHandle)e.getValue())), this.tableScanNode.getCurrentConstraint(), this.tableScanNode.getEnforcedConstraint()));
        }

        public PlanNode visitPlan(PlanNode node, Void context) {
            Optional<PlanNode> pushedDownPlan = this.tryCreatingNewScanNode(node);
            return pushedDownPlan.orElseGet(() -> DruidPlanOptimizer.replaceChildren(node, (List)node.getSources().stream().map(source -> (PlanNode)source.accept((PlanVisitor)this, null)).collect(ImmutableList.toImmutableList())));
        }

        public PlanNode visitFilter(FilterNode node, Void context) {
            if (this.filtersSplitUp.containsKey(node)) {
                return this.visitPlan((PlanNode)node, context);
            }
            this.filtersSplitUp.put(node, null);
            FilterNode nodeToRecurseInto = node;
            ArrayList<RowExpression> pushable = new ArrayList<RowExpression>();
            ArrayList<RowExpression> nonPushable = new ArrayList<RowExpression>();
            DruidFilterExpressionConverter druidFilterExpressionConverter = new DruidFilterExpressionConverter(DruidPlanOptimizer.this.typeManager, DruidPlanOptimizer.this.functionMetadataManager, DruidPlanOptimizer.this.standardFunctionResolution, this.session);
            for (RowExpression conjunct : LogicalRowExpressions.extractConjuncts((RowExpression)node.getPredicate())) {
                try {
                    conjunct.accept((RowExpressionVisitor)druidFilterExpressionConverter, var -> new DruidQueryGeneratorContext.Selection(var.getName(), DruidQueryGeneratorContext.Origin.DERIVED));
                    pushable.add(conjunct);
                }
                catch (PrestoException e) {
                    nonPushable.add(conjunct);
                }
            }
            if (!pushable.isEmpty()) {
                FilterNode pushableFilter = new FilterNode(this.idAllocator.getNextId(), node.getSource(), DruidPlanOptimizer.this.logicalRowExpressions.combineConjuncts(pushable));
                Optional nonPushableFilter = nonPushable.isEmpty() ? Optional.empty() : Optional.of(new FilterNode(this.idAllocator.getNextId(), (PlanNode)pushableFilter, DruidPlanOptimizer.this.logicalRowExpressions.combineConjuncts(nonPushable)));
                this.filtersSplitUp.put(pushableFilter, null);
                if (nonPushableFilter.isPresent()) {
                    FilterNode nonPushableFilterNode = (FilterNode)nonPushableFilter.get();
                    this.filtersSplitUp.put(nonPushableFilterNode, null);
                    nodeToRecurseInto = nonPushableFilterNode;
                } else {
                    nodeToRecurseInto = pushableFilter;
                }
            }
            return this.visitFilter(nodeToRecurseInto, context);
        }
    }

    private static class TableFindingVisitor
    extends PlanVisitor<Map<TableScanNode, Void>, Void> {
        private TableFindingVisitor() {
        }

        public Map<TableScanNode, Void> visitPlan(PlanNode node, Void context) {
            IdentityHashMap<TableScanNode, Void> result = new IdentityHashMap<TableScanNode, Void>();
            node.getSources().forEach(source -> result.putAll((Map)source.accept((PlanVisitor)this, (Object)context)));
            return result;
        }

        public Map<TableScanNode, Void> visitTableScan(TableScanNode node, Void context) {
            IdentityHashMap<TableScanNode, Void> result = new IdentityHashMap<TableScanNode, Void>();
            result.put(node, null);
            return result;
        }
    }
}

