/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class DruidColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final Type columnType;
    private final DruidColumnType type;

    public DruidColumnHandle(VariableReferenceExpression variable, DruidColumnType type) {
        this(variable.getName(), variable.getType(), type);
    }

    public DruidColumnHandle(String columnName, Type columnType) {
        this(columnName, columnType, DruidColumnType.REGULAR);
    }

    @JsonCreator
    public DruidColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="type") DruidColumnType type) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public DruidColumnType getType() {
        return this.type;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.getColumnName(), this.getColumnType());
    }

    public int hashCode() {
        return Objects.hash(this.columnName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DruidColumnHandle other = (DruidColumnHandle)obj;
        return Objects.equals(this.columnName, other.columnName) && Objects.equals(this.columnType, other.columnType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("columnType", (Object)this.columnType).add("type", (Object)this.type).toString();
    }

    public static enum DruidColumnType {
        REGULAR,
        DERIVED;

    }
}

