/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.http.client.StringResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.druid.DruidConfig;
import com.facebook.presto.druid.ForDruidClient;
import com.facebook.presto.druid.metadata.DruidColumnInfo;
import com.facebook.presto.druid.metadata.DruidSegmentIdWrapper;
import com.facebook.presto.druid.metadata.DruidSegmentInfo;
import com.facebook.presto.druid.metadata.DruidTableInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class DruidClient {
    private static final String METADATA_PATH = "/druid/coordinator/v1/metadata";
    private static final String SQL_ENDPOINT = "/druid/v2/sql";
    private static final String LIST_TABLE_QUERY = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'druid'";
    private static final String GET_COLUMN_TEMPLATE = "SELECT COLUMN_NAME, DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = '%s'";
    private static final String GET_SEGMENTS_ID_TEMPLATE = "SELECT segment_id FROM sys.segments WHERE datasource = '%s' AND is_published = 1";
    private static final JsonCodec<List<DruidSegmentIdWrapper>> LIST_SEGMENT_ID_CODEC = JsonCodec.listJsonCodec(DruidSegmentIdWrapper.class);
    private static final JsonCodec<List<DruidColumnInfo>> LIST_COLUMN_INFO_CODEC = JsonCodec.listJsonCodec(DruidColumnInfo.class);
    private static final JsonCodec<List<DruidTableInfo>> LIST_TABLE_NAME_CODEC = JsonCodec.listJsonCodec(DruidTableInfo.class);
    private static final JsonCodec<DruidSegmentInfo> SEGMENT_INFO_CODEC = JsonCodec.jsonCodec(DruidSegmentInfo.class);
    private final HttpClient httpClient;
    private final URI druidCoordinator;
    private final URI druidBroker;
    private final String druidSchema;

    @Inject
    public DruidClient(DruidConfig config, @ForDruidClient HttpClient httpClient) {
        Objects.requireNonNull(config, "config is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.druidCoordinator = URI.create(config.getDruidCoordinatorUrl());
        this.druidBroker = URI.create(config.getDruidBrokerUrl());
        this.druidSchema = config.getDruidSchema();
    }

    public URI getDruidBroker() {
        return this.druidBroker;
    }

    public String getSchema() {
        return this.druidSchema;
    }

    public List<String> getSchemas() {
        return ImmutableList.of((Object)this.druidSchema);
    }

    public List<String> getTables() {
        return (List)((List)this.httpClient.execute(this.prepareQuery(LIST_TABLE_QUERY), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(LIST_TABLE_NAME_CODEC))).stream().map(DruidTableInfo::getTableName).collect(ImmutableList.toImmutableList());
    }

    public List<DruidColumnInfo> getColumnDataType(String tableName) {
        return (List)this.httpClient.execute(this.prepareQuery(String.format(GET_COLUMN_TEMPLATE, tableName)), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(LIST_COLUMN_INFO_CODEC));
    }

    public List<String> getDataSegmentId(String tableName) {
        return (List)((List)this.httpClient.execute(this.prepareQuery(String.format(GET_SEGMENTS_ID_TEMPLATE, tableName)), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(LIST_SEGMENT_ID_CODEC))).stream().map(wrapper -> wrapper.getSegmentId()).collect(ImmutableList.toImmutableList());
    }

    public DruidSegmentInfo getSingleSegmentInfo(String dataSource, String segmentId) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.druidCoordinator).replacePath(METADATA_PATH).appendPath(String.format("datasources/%s/segments/%s", dataSource, segmentId)).build();
        Request request = DruidClient.setContentTypeHeaders(Request.Builder.prepareGet()).setUri(uri).build();
        return (DruidSegmentInfo)this.httpClient.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(SEGMENT_INFO_CODEC));
    }

    public String getData(String dql) {
        return ((StringResponseHandler.StringResponse)this.httpClient.execute(this.prepareQuery(dql), (ResponseHandler)StringResponseHandler.createStringResponseHandler())).getBody();
    }

    private static Request.Builder setContentTypeHeaders(Request.Builder requestBuilder) {
        return requestBuilder.setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).setHeader("Accept", MediaType.JSON_UTF_8.toString());
    }

    private static byte[] createRequestBody(String query) {
        return String.format("{\"query\":\"%s\"}\n", query).getBytes();
    }

    private Request prepareQuery(String query) {
        HttpUriBuilder uriBuilder = HttpUriBuilder.uriBuilderFrom((URI)this.druidBroker).replacePath(SQL_ENDPOINT);
        return DruidClient.setContentTypeHeaders(Request.Builder.preparePost()).setUri(uriBuilder.build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])DruidClient.createRequestBody(query))).build();
    }
}

