/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.airlift.json.ObjectMapperProvider;
import com.facebook.presto.druid.DruidClient;
import com.facebook.presto.druid.DruidColumnHandle;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.DruidQueryGenerator;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DruidBrokerPageSource
implements ConnectorPageSource {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private final DruidQueryGenerator.GeneratedDql brokerDql;
    private final List<ColumnHandle> columnHandles;
    private final DruidClient druidClient;
    private boolean finished;
    private long readTimeNanos;
    private long completedBytes;
    private long completedPositions;

    public DruidBrokerPageSource(DruidQueryGenerator.GeneratedDql brokerDql, List<ColumnHandle> columnHandles, DruidClient druidClient) {
        this.brokerDql = Objects.requireNonNull(brokerDql, "broker is null");
        this.columnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnHandles, "columnHandles is null"));
        this.druidClient = Objects.requireNonNull(druidClient, "druid client is null");
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getNextPage() {
        if (this.finished) {
            return null;
        }
        long start = System.nanoTime();
        try {
            JsonNode rootNode;
            List handles = (List)this.columnHandles.stream().map(column -> (DruidColumnHandle)column).collect(ImmutableList.toImmutableList());
            List columnTypes = (List)handles.stream().map(DruidColumnHandle::getColumnType).collect(ImmutableList.toImmutableList());
            PageBuilder pageBuilder = new PageBuilder(columnTypes);
            String data = this.druidClient.getData(this.brokerDql.getDql());
            try {
                rootNode = OBJECT_MAPPER.readTree(data);
                Preconditions.checkArgument((boolean)rootNode.isArray(), (Object)"broker Druid query should return Json Array");
                ArrayNode arrayNode = (ArrayNode)rootNode;
                Iterator iterator = arrayNode.elements();
                while (iterator.hasNext()) {
                    JsonNode node = (JsonNode)iterator.next();
                    Iterator fieldNamesIterator = node.fieldNames();
                    for (int i = 0; i < this.columnHandles.size(); ++i) {
                        Type type = (Type)columnTypes.get(i);
                        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                        String fieldName = (String)fieldNamesIterator.next();
                        JsonNode value = node.get(fieldName);
                        if (value == null) {
                            blockBuilder.appendNull();
                            continue;
                        }
                        if (type instanceof BigintType) {
                            type.writeLong(blockBuilder, value.longValue());
                            continue;
                        }
                        if (type instanceof DoubleType) {
                            type.writeDouble(blockBuilder, value.doubleValue());
                            continue;
                        }
                        if (type instanceof RealType) {
                            type.writeDouble(blockBuilder, value.doubleValue());
                            continue;
                        }
                        if (type instanceof TimestampType) {
                            DateTimeFormatter formatter = ISODateTimeFormat.dateTimeParser().withChronology((Chronology)ISOChronology.getInstanceUTC()).withOffsetParsed();
                            DateTime dateTime = formatter.parseDateTime(value.textValue());
                            type.writeLong(blockBuilder, dateTime.getMillis());
                            continue;
                        }
                        Slice slice = Slices.utf8Slice((String)value.textValue());
                        blockBuilder.writeBytes(slice, 0, slice.length()).closeEntry();
                        this.completedBytes += (long)slice.length();
                    }
                }
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_BROKER_RESULT_ERROR, (Throwable)e);
            }
            pageBuilder.declarePositions(rootNode.size());
            Page page = pageBuilder.build();
            this.completedPositions += (long)page.getPositionCount();
            this.finished = true;
            Page page2 = page;
            return page2;
        }
        finally {
            this.readTimeNanos += System.nanoTime() - start;
        }
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
        this.finished = true;
    }
}

