/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.array;

import com.facebook.presto.common.array.IntComparator;

public class IntBigArrays {
    private static final int SEGMENT_MASK = 1023;
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private IntBigArrays() {
    }

    public static int segment(long index) {
        return (int)(index >>> 10);
    }

    public static int displacement(long index) {
        return (int)(index & 0x3FFL);
    }

    public static int get(int[][] array, long index) {
        return array[IntBigArrays.segment(index)][IntBigArrays.displacement(index)];
    }

    public static void set(int[][] array, long index, int value) {
        array[IntBigArrays.segment((long)index)][IntBigArrays.displacement((long)index)] = value;
    }

    public static void swap(int[][] array, long first, long second) {
        int t = array[IntBigArrays.segment(first)][IntBigArrays.displacement(first)];
        array[IntBigArrays.segment((long)first)][IntBigArrays.displacement((long)first)] = array[IntBigArrays.segment(second)][IntBigArrays.displacement(second)];
        array[IntBigArrays.segment((long)second)][IntBigArrays.displacement((long)second)] = t;
    }

    public static void quickSort(int[][] x, long from, long to, IntComparator comp) {
        long c;
        long a;
        long len = to - from;
        if (len < 7L) {
            IntBigArrays.selectionSort(x, from, to, comp);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = IntBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = IntBigArrays.med3(x, m - s, m, m + s, comp);
                n = IntBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = IntBigArrays.med3(x, l, m, n, comp);
        }
        int v = IntBigArrays.get(x, m);
        long b = a = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(IntBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    IntBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(IntBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    IntBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntBigArrays.swap(x, b++, c--);
        }
        long s = Math.min(a - from, b - a);
        IntBigArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1L);
        IntBigArrays.vecSwap(x, b, to - s, s);
        s = b - a;
        if (s > 1L) {
            IntBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1L) {
            IntBigArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static void vecSwap(int[][] x, long a, long b, long n) {
        int i = 0;
        while ((long)i < n) {
            IntBigArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static long med3(int[][] x, long a, long b, long c, IntComparator comp) {
        int ab = comp.compare(IntBigArrays.get(x, a), IntBigArrays.get(x, b));
        int ac = comp.compare(IntBigArrays.get(x, a), IntBigArrays.get(x, c));
        int bc = comp.compare(IntBigArrays.get(x, b), IntBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(int[][] a, long from, long to, IntComparator comp) {
        for (long i = from; i < to - 1L; ++i) {
            long m = i;
            for (long j = i + 1L; j < to; ++j) {
                if (comp.compare(IntBigArrays.get(a, j), IntBigArrays.get(a, m)) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            IntBigArrays.swap(a, i, m);
        }
    }
}

