/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.DictionaryId;
import io.airlift.slice.SizeOf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.openjdk.jol.info.ClassLayout;

public final class Page {
    public static final int INSTANCE_SIZE = ClassLayout.parseClass(Page.class).instanceSize();
    private static final Block[] EMPTY_BLOCKS = new Block[0];
    private final Block[] blocks;
    private final int positionCount;
    private volatile long sizeInBytes = -1L;
    private volatile long retainedSizeInBytes = -1L;
    private volatile long logicalSizeInBytes = -1L;

    public static Page wrapBlocksWithoutCopy(int positionCount, Block[] blocks) {
        return new Page(false, positionCount, blocks);
    }

    public Page(Block ... blocks) {
        this(true, Page.determinePositionCount(blocks), blocks);
    }

    public Page(int positionCount) {
        this(false, positionCount, EMPTY_BLOCKS);
    }

    public Page(int positionCount, Block ... blocks) {
        this(true, positionCount, blocks);
    }

    private Page(boolean blocksCopyRequired, int positionCount, Block[] blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        this.positionCount = positionCount;
        if (blocks.length == 0) {
            this.sizeInBytes = 0L;
            this.logicalSizeInBytes = 0L;
            this.blocks = EMPTY_BLOCKS;
            this.retainedSizeInBytes = INSTANCE_SIZE;
        } else {
            this.blocks = blocksCopyRequired ? (Block[])blocks.clone() : blocks;
        }
    }

    public int getChannelCount() {
        return this.blocks.length;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getSizeInBytes() {
        long sizeInBytes = this.sizeInBytes;
        if (sizeInBytes < 0L) {
            sizeInBytes = 0L;
            for (Block block : this.blocks) {
                sizeInBytes += block.getSizeInBytes();
            }
            this.sizeInBytes = sizeInBytes;
        }
        return sizeInBytes;
    }

    public long getLogicalSizeInBytes() {
        long logicalSizeInBytes = this.logicalSizeInBytes;
        if (logicalSizeInBytes < 0L) {
            logicalSizeInBytes = 0L;
            for (Block block : this.blocks) {
                logicalSizeInBytes += block.getLogicalSizeInBytes();
            }
            this.logicalSizeInBytes = logicalSizeInBytes;
        }
        return logicalSizeInBytes;
    }

    public long getApproximateLogicalSizeInBytes() {
        if (this.logicalSizeInBytes < 0L) {
            long approximateLogicalSizeInBytes = 0L;
            for (Block block : this.blocks) {
                approximateLogicalSizeInBytes += block.getApproximateRegionLogicalSizeInBytes(0, block.getPositionCount());
            }
            return approximateLogicalSizeInBytes;
        }
        return this.logicalSizeInBytes;
    }

    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = this.retainedSizeInBytes;
        if (retainedSizeInBytes < 0L) {
            return this.updateRetainedSize();
        }
        return retainedSizeInBytes;
    }

    public Block getBlock(int channel) {
        return this.blocks[channel];
    }

    public Page getSingleValuePage(int position) {
        Block[] singleValueBlocks = new Block[this.blocks.length];
        for (int i = 0; i < this.blocks.length; ++i) {
            singleValueBlocks[i] = this.blocks[i].getSingleValueBlock(position);
        }
        return Page.wrapBlocksWithoutCopy(1, singleValueBlocks);
    }

    public Page getRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid position %s and length %s in page with %s positions", positionOffset, length, this.positionCount));
        }
        if (positionOffset == 0 && length == this.positionCount) {
            return this;
        }
        int channelCount = this.getChannelCount();
        Block[] slicedBlocks = new Block[channelCount];
        for (int i = 0; i < channelCount; ++i) {
            slicedBlocks[i] = this.blocks[i].getRegion(positionOffset, length);
        }
        return Page.wrapBlocksWithoutCopy(length, slicedBlocks);
    }

    public Page appendColumn(Block block) {
        Objects.requireNonNull(block, "block is null");
        if (this.positionCount != block.getPositionCount()) {
            throw new IllegalArgumentException("Block does not have same position count");
        }
        Block[] newBlocks = Arrays.copyOf(this.blocks, this.blocks.length + 1);
        newBlocks[this.blocks.length] = block;
        return Page.wrapBlocksWithoutCopy(this.positionCount, newBlocks);
    }

    public Page compact() {
        if (this.getRetainedSizeInBytes() <= this.getSizeInBytes()) {
            return this;
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            Block block = this.blocks[i];
            if (block instanceof DictionaryBlock) continue;
            this.blocks[i] = block.copyRegion(0, block.getPositionCount());
        }
        Map<DictionaryId, DictionaryBlockIndexes> dictionaryBlocks = this.getRelatedDictionaryBlocks();
        for (DictionaryBlockIndexes blockIndexes : dictionaryBlocks.values()) {
            List<DictionaryBlock> compactBlocks = Page.compactRelatedBlocks(blockIndexes.getBlocks());
            List<Integer> indexes = blockIndexes.getIndexes();
            for (int i = 0; i < compactBlocks.size(); ++i) {
                this.blocks[indexes.get((int)i).intValue()] = compactBlocks.get(i);
            }
        }
        this.updateRetainedSize();
        return this;
    }

    private Map<DictionaryId, DictionaryBlockIndexes> getRelatedDictionaryBlocks() {
        HashMap<DictionaryId, DictionaryBlockIndexes> relatedDictionaryBlocks = new HashMap<DictionaryId, DictionaryBlockIndexes>();
        for (int i = 0; i < this.blocks.length; ++i) {
            Block block = this.blocks[i];
            if (!(block instanceof DictionaryBlock)) continue;
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            relatedDictionaryBlocks.computeIfAbsent(dictionaryBlock.getDictionarySourceId(), id -> new DictionaryBlockIndexes()).addBlock(dictionaryBlock, i);
        }
        return relatedDictionaryBlocks;
    }

    private static List<DictionaryBlock> compactRelatedBlocks(List<DictionaryBlock> blocks) {
        DictionaryBlock firstDictionaryBlock = blocks.get(0);
        Block dictionary = firstDictionaryBlock.getDictionary();
        int positionCount = firstDictionaryBlock.getPositionCount();
        int dictionarySize = dictionary.getPositionCount();
        int[] dictionaryPositionsToCopy = new int[Math.min(dictionarySize, positionCount)];
        int[] remapIndex = new int[dictionarySize];
        Arrays.fill(remapIndex, -1);
        int numberOfIndexes = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = firstDictionaryBlock.getId(i);
            if (remapIndex[position] != -1) continue;
            dictionaryPositionsToCopy[numberOfIndexes] = position;
            remapIndex[position] = numberOfIndexes++;
        }
        if (numberOfIndexes == dictionarySize) {
            return blocks;
        }
        int[] newIds = Page.getNewIds(positionCount, firstDictionaryBlock, remapIndex);
        ArrayList<DictionaryBlock> outputDictionaryBlocks = new ArrayList<DictionaryBlock>(blocks.size());
        DictionaryId newDictionaryId = DictionaryId.randomDictionaryId();
        for (DictionaryBlock dictionaryBlock : blocks) {
            if (!firstDictionaryBlock.getDictionarySourceId().equals(dictionaryBlock.getDictionarySourceId())) {
                throw new IllegalArgumentException("dictionarySourceIds must be the same");
            }
            try {
                Block compactDictionary = dictionaryBlock.getDictionary().copyPositions(dictionaryPositionsToCopy, 0, numberOfIndexes);
                outputDictionaryBlocks.add(new DictionaryBlock(positionCount, compactDictionary, newIds, true, newDictionaryId));
            }
            catch (UnsupportedOperationException e) {
                outputDictionaryBlocks.add(dictionaryBlock);
            }
        }
        return outputDictionaryBlocks;
    }

    private static int[] getNewIds(int positionCount, DictionaryBlock dictionaryBlock, int[] remapIndex) {
        int[] newIds = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            int newId = remapIndex[dictionaryBlock.getId(i)];
            if (newId == -1) {
                throw new IllegalStateException("reference to a non-existent key");
            }
            newIds[i] = newId;
        }
        return newIds;
    }

    public Page getLoadedPage() {
        for (int i = 0; i < this.blocks.length; ++i) {
            Block loaded = this.blocks[i].getLoadedBlock();
            if (loaded == this.blocks[i]) continue;
            Block[] loadedBlocks = (Block[])this.blocks.clone();
            loadedBlocks[i++] = loaded;
            while (i < this.blocks.length) {
                loadedBlocks[i] = this.blocks[i].getLoadedBlock();
                ++i;
            }
            return Page.wrapBlocksWithoutCopy(this.positionCount, loadedBlocks);
        }
        return this;
    }

    public Page getLoadedPage(int channel) {
        return Page.wrapBlocksWithoutCopy(this.positionCount, new Block[]{this.blocks[channel].getLoadedBlock()});
    }

    public Page getLoadedPage(int ... channels) {
        Objects.requireNonNull(channels, "channels is null");
        Block[] blocks = new Block[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            blocks[i] = this.blocks[channels[i]].getLoadedBlock();
        }
        return Page.wrapBlocksWithoutCopy(this.positionCount, blocks);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Page{");
        builder.append("positions=").append(this.positionCount);
        builder.append(", channels=").append(this.getChannelCount());
        builder.append('}');
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        return builder.toString();
    }

    private static int determinePositionCount(Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        if (blocks.length == 0) {
            throw new IllegalArgumentException("blocks is empty");
        }
        return blocks[0].getPositionCount();
    }

    public Page getPositions(int[] retainedPositions, int offset, int length) {
        Objects.requireNonNull(retainedPositions, "retainedPositions is null");
        Block[] blocks = new Block[this.blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.blocks[i].getPositions(retainedPositions, offset, length);
        }
        return Page.wrapBlocksWithoutCopy(length, blocks);
    }

    public Page copyPositions(int[] retainedPositions, int offset, int length) {
        Objects.requireNonNull(retainedPositions, "retainedPositions is null");
        Block[] blocks = new Block[this.blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.blocks[i].copyPositions(retainedPositions, offset, length);
        }
        return Page.wrapBlocksWithoutCopy(length, blocks);
    }

    public Page extractChannel(int channel) {
        return Page.wrapBlocksWithoutCopy(this.positionCount, new Block[]{this.blocks[channel]});
    }

    public Page extractChannels(int[] channels) {
        Objects.requireNonNull(channels, "channels is null");
        Block[] blocks = new Block[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            blocks[i] = this.blocks[channels[i]];
        }
        return Page.wrapBlocksWithoutCopy(this.positionCount, blocks);
    }

    public Page prependColumn(Block column) {
        if (column.getPositionCount() != this.positionCount) {
            throw new IllegalArgumentException(String.format("Column does not have same position count (%s) as page (%s)", column.getPositionCount(), this.positionCount));
        }
        Block[] result = new Block[this.blocks.length + 1];
        result[0] = column;
        System.arraycopy(this.blocks, 0, result, 1, this.blocks.length);
        return Page.wrapBlocksWithoutCopy(this.positionCount, result);
    }

    public Page dropColumn(int channelIndex) {
        if (channelIndex < 0 || channelIndex >= this.getChannelCount()) {
            throw new IndexOutOfBoundsException(String.format("Invalid channel %d in page with %s channels", channelIndex, this.getChannelCount()));
        }
        Block[] result = new Block[this.getChannelCount() - 1];
        System.arraycopy(this.blocks, 0, result, 0, channelIndex);
        System.arraycopy(this.blocks, channelIndex + 1, result, channelIndex, this.getChannelCount() - channelIndex - 1);
        return Page.wrapBlocksWithoutCopy(this.positionCount, result);
    }

    private long updateRetainedSize() {
        AtomicLong retainedSizeInBytes = new AtomicLong((long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.blocks));
        Set referenceSet = Collections.newSetFromMap(new IdentityHashMap());
        for (Block block : this.blocks) {
            block.retainedBytesForEachPart((object, size) -> {
                if (referenceSet.add(object)) {
                    retainedSizeInBytes.addAndGet(size);
                }
            });
        }
        this.retainedSizeInBytes = retainedSizeInBytes.longValue();
        return retainedSizeInBytes.longValue();
    }

    public Page replaceColumn(int channelIndex, Block column) {
        if (column.getPositionCount() != this.positionCount) {
            throw new IllegalArgumentException("New column does not have same number of rows as old column");
        }
        Block[] newBlocks = Arrays.copyOf(this.blocks, this.blocks.length);
        newBlocks[channelIndex] = column;
        return Page.wrapBlocksWithoutCopy(newBlocks.length, newBlocks);
    }

    private static class DictionaryBlockIndexes {
        private final List<DictionaryBlock> blocks = new ArrayList<DictionaryBlock>();
        private final List<Integer> indexes = new ArrayList<Integer>();

        private DictionaryBlockIndexes() {
        }

        public void addBlock(DictionaryBlock block, int index) {
            this.blocks.add(block);
            this.indexes.add(index);
        }

        public List<DictionaryBlock> getBlocks() {
            return this.blocks;
        }

        public List<Integer> getIndexes() {
            return this.indexes;
        }
    }
}

