/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.array;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.array.ReferenceCountMap;
import com.facebook.presto.common.block.Block;
import org.openjdk.jol.info.ClassLayout;

public final class BlockBigArray {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BlockBigArray.class).instanceSize();
    private final ObjectBigArray<Block> array;
    private final ReferenceCountMap trackedObjects = new ReferenceCountMap();
    private long sizeOfBlocks;

    public BlockBigArray() {
        this.array = new ObjectBigArray();
    }

    public BlockBigArray(Block block) {
        this.array = new ObjectBigArray(block);
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.array.sizeOf() + this.sizeOfBlocks + this.trackedObjects.sizeOf();
    }

    public Block get(long index) {
        return this.array.get(index);
    }

    public void set(long index, Block value) {
        Block currentValue = this.array.get(index);
        if (currentValue != null) {
            currentValue.retainedBytesForEachPart((object, size) -> {
                if (currentValue == object) {
                    this.sizeOfBlocks -= size.longValue();
                    return;
                }
                if (this.trackedObjects.decrementAndGet(object) == 0) {
                    this.sizeOfBlocks -= size.longValue();
                }
            });
        }
        if (value != null) {
            value.retainedBytesForEachPart((object, size) -> {
                if (value == object) {
                    this.sizeOfBlocks += size.longValue();
                    return;
                }
                if (this.trackedObjects.incrementAndGet(object) == 1) {
                    this.sizeOfBlocks += size.longValue();
                }
            });
        }
        this.array.set(index, value);
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }
}

