/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.block.AbstractMapBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.BlockUtil;
import com.facebook.presto.common.block.DuplicateMapKeyException;
import com.facebook.presto.common.block.MapBlock;
import com.facebook.presto.common.block.SingleMapBlock;
import com.facebook.presto.common.block.SingleMapBlockWriter;
import com.facebook.presto.common.type.Type;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceInput;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class MapBlockBuilder
extends AbstractMapBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapBlockBuilder.class).instanceSize();
    private final MethodHandle keyBlockEquals;
    private final MethodHandle keyBlockHashCode;
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private int positionCount;
    private int[] offsets;
    private boolean[] mapIsNull;
    private final BlockBuilder keyBlockBuilder;
    private final BlockBuilder valueBlockBuilder;
    private final AbstractMapBlock.HashTables hashTables;
    private boolean currentEntryOpened;

    public MapBlockBuilder(Type keyType, Type valueType, MethodHandle keyBlockEquals, MethodHandle keyBlockHashCode, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(keyBlockEquals, keyBlockHashCode, blockBuilderStatus, keyType.createBlockBuilder(blockBuilderStatus, expectedEntries), valueType.createBlockBuilder(blockBuilderStatus, expectedEntries), expectedEntries, null);
    }

    private MapBlockBuilder(MethodHandle keyBlockEquals, MethodHandle keyBlockHashCode, @Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder, int expectedEntries, @Nullable int[] rawHashTables) {
        this.keyBlockEquals = Objects.requireNonNull(keyBlockEquals, "keyBlockEquals is null");
        this.keyBlockHashCode = Objects.requireNonNull(keyBlockHashCode, "keyBlockHashCode is null");
        this.blockBuilderStatus = blockBuilderStatus;
        this.positionCount = 0;
        this.offsets = new int[expectedEntries + 1];
        this.mapIsNull = new boolean[expectedEntries];
        this.keyBlockBuilder = Objects.requireNonNull(keyBlockBuilder, "keyBlockBuilder is null");
        this.valueBlockBuilder = Objects.requireNonNull(valueBlockBuilder, "valueBlockBuilder is null");
        this.hashTables = new AbstractMapBlock.HashTables(Optional.ofNullable(rawHashTables), 0);
        this.logicalSizeInBytes = -1L;
    }

    @Override
    protected Block getRawKeyBlock() {
        return this.keyBlockBuilder;
    }

    @Override
    protected Block getRawValueBlock() {
        return this.valueBlockBuilder;
    }

    @Override
    protected AbstractMapBlock.HashTables getHashTables() {
        return this.hashTables;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    public int getOffsetBase() {
        return 0;
    }

    @Override
    protected boolean[] getMapIsNull() {
        return this.mapIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.keyBlockBuilder.getSizeInBytes() + this.valueBlockBuilder.getSizeInBytes() + 5L * (long)this.positionCount + 8L * (long)this.keyBlockBuilder.getPositionCount();
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((boolean[])this.mapIsNull) + this.hashTables.getRetainedSizeInBytes();
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.keyBlockBuilder, this.keyBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this.valueBlockBuilder, this.valueBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        consumer.accept(this.mapIsNull, SizeOf.sizeOf((boolean[])this.mapIsNull));
        consumer.accept(this.hashTables, this.hashTables.getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public Block getSingleValueBlock(int position) {
        return this.getSingleValueBlockInternal(position);
    }

    @Override
    public SingleMapBlockWriter beginBlockEntry() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        return new SingleMapBlockWriter(this.keyBlockBuilder.getPositionCount() * 2, this.keyBlockBuilder, this.valueBlockBuilder);
    }

    @Override
    public BlockBuilder closeEntry() {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        if (this.isHashTablesPresent()) {
            int[] rawHashTables = this.ensureHashTableSize();
            int previousAggregatedEntryCount = this.offsets[this.positionCount - 1];
            int aggregatedEntryCount = this.offsets[this.positionCount];
            int entryCount = aggregatedEntryCount - previousAggregatedEntryCount;
            MapBlockBuilder.verify(rawHashTables != null, "rawHashTables is null");
            MapBlockBuilder.buildHashTable(this.keyBlockBuilder, previousAggregatedEntryCount, entryCount, this.keyBlockHashCode, rawHashTables, previousAggregatedEntryCount * 2, entryCount * 2);
        }
        return this;
    }

    public BlockBuilder closeEntryStrict(MethodHandle keyBlockEquals, MethodHandle keyBlockHashCode) throws DuplicateMapKeyException, NotSupportedException {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.ensureHashTableLoaded(keyBlockHashCode);
        this.entryAdded(false);
        this.currentEntryOpened = false;
        int[] rawHashTables = this.ensureHashTableSize();
        int previousAggregatedEntryCount = this.offsets[this.positionCount - 1];
        int aggregatedEntryCount = this.offsets[this.positionCount];
        int entryCount = aggregatedEntryCount - previousAggregatedEntryCount;
        MapBlockBuilder.verify(rawHashTables != null, "rawHashTables is null");
        MapBlockBuilder.buildHashTableStrict(this.keyBlockBuilder, previousAggregatedEntryCount, entryCount, keyBlockEquals, keyBlockHashCode, rawHashTables, previousAggregatedEntryCount * 2, entryCount * 2);
        return this;
    }

    private void closeEntry(@Nullable int[] providedHashTable, int providedHashTableOffset) {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        if (providedHashTable != null) {
            this.ensureHashTableLoaded(this.keyBlockHashCode);
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        if (this.isHashTablesPresent()) {
            int[] rawHashTables = this.ensureHashTableSize();
            int previousAggregatedEntryCount = this.offsets[this.positionCount - 1];
            int aggregatedEntryCount = this.offsets[this.positionCount];
            if (providedHashTable != null) {
                int hashTableOffset = previousAggregatedEntryCount * 2;
                int hashTableSize = (aggregatedEntryCount - previousAggregatedEntryCount) * 2;
                System.arraycopy(providedHashTable, providedHashTableOffset, rawHashTables, hashTableOffset, hashTableSize);
            } else {
                int entryCount = aggregatedEntryCount - previousAggregatedEntryCount;
                MapBlockBuilder.buildHashTable(this.keyBlockBuilder, previousAggregatedEntryCount, entryCount, this.keyBlockHashCode, rawHashTables, previousAggregatedEntryCount * 2, entryCount * 2);
            }
        }
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.keyBlockBuilder.getPositionCount() != this.valueBlockBuilder.getPositionCount()) {
            throw new IllegalStateException(String.format("keyBlock and valueBlock has different size: %s %s", this.keyBlockBuilder.getPositionCount(), this.valueBlockBuilder.getPositionCount()));
        }
        if (this.mapIsNull.length <= this.positionCount) {
            int newSize = BlockUtil.calculateNewArraySize(this.mapIsNull.length);
            this.mapIsNull = Arrays.copyOf(this.mapIsNull, newSize);
            this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        }
        this.offsets[this.positionCount + 1] = this.keyBlockBuilder.getPositionCount();
        this.mapIsNull[this.positionCount] = isNull;
        ++this.positionCount;
        this.hashTables.setExpectedHashTableCount(this.positionCount);
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
            this.blockBuilderStatus.addBytes((this.offsets[this.positionCount] - this.offsets[this.positionCount - 1]) * 2 * 4);
        }
    }

    private int[] ensureHashTableSize() {
        int[] rawHashTables = this.hashTables.get();
        MapBlockBuilder.verify(rawHashTables != null, "rawHashTables is null");
        if (rawHashTables.length < this.offsets[this.positionCount] * 2) {
            int newSize = BlockUtil.calculateNewArraySize(this.offsets[this.positionCount] * 2);
            int[] newRawHashTables = Arrays.copyOf(rawHashTables, newSize);
            Arrays.fill(newRawHashTables, rawHashTables.length, newSize, -1);
            this.hashTables.set(newRawHashTables);
            return newRawHashTables;
        }
        return rawHashTables;
    }

    @Override
    public BlockBuilder readPositionFrom(SliceInput input) {
        boolean isNull;
        boolean bl = isNull = input.readByte() == 0;
        if (isNull) {
            this.appendNull();
        } else {
            int length = input.readInt();
            SingleMapBlockWriter singleMapBlockWriter = this.beginBlockEntry();
            for (int i = 0; i < length; ++i) {
                singleMapBlockWriter.readPositionFrom(input);
                singleMapBlockWriter.readPositionFrom(input);
            }
            this.closeEntry();
        }
        return this;
    }

    @Override
    public Block build() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        int[] rawHashTables = this.hashTables.get();
        int hashTablesEntries = this.offsets[this.positionCount] * 2;
        int[] mapBlockHashTables = rawHashTables == null ? null : Arrays.copyOf(rawHashTables, hashTablesEntries);
        return MapBlock.createMapBlockInternal(0, this.positionCount, Optional.of(this.mapIsNull), this.offsets, this.keyBlockBuilder.build(), this.valueBlockBuilder.build(), new AbstractMapBlock.HashTables(Optional.ofNullable(mapBlockHashTables), this.positionCount));
    }

    public String toString() {
        return String.format("MapBlockBuilder(%d){positionCount=%d}", this.hashCode(), this.getPositionCount());
    }

    @Override
    public BlockBuilder appendStructure(Block block) {
        if (!(block instanceof SingleMapBlock)) {
            throw new IllegalArgumentException("Expected SingleMapBlock");
        }
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        SingleMapBlock singleMapBlock = (SingleMapBlock)block;
        int blockPositionCount = singleMapBlock.getPositionCount();
        if (blockPositionCount % 2 != 0) {
            throw new IllegalArgumentException(String.format("block position count is not even: %s", blockPositionCount));
        }
        for (int i = 0; i < blockPositionCount; i += 2) {
            if (singleMapBlock.isNull(i)) {
                throw new IllegalArgumentException("Map keys must not be null");
            }
            singleMapBlock.writePositionTo(i, this.keyBlockBuilder);
            if (singleMapBlock.isNull(i + 1)) {
                this.valueBlockBuilder.appendNull();
                continue;
            }
            singleMapBlock.writePositionTo(i + 1, this.valueBlockBuilder);
        }
        this.closeEntry(singleMapBlock.getHashTable(), singleMapBlock.getOffsetBase() / 2 * 2);
        return this;
    }

    @Override
    public BlockBuilder appendStructureInternal(Block block, int position) {
        if (!(block instanceof AbstractMapBlock)) {
            throw new IllegalArgumentException("Expected AbstractMapBlock");
        }
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        AbstractMapBlock mapBlock = (AbstractMapBlock)block;
        int startValueOffset = mapBlock.getOffset(position);
        int endValueOffset = mapBlock.getOffset(position + 1);
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            if (mapBlock.getRawKeyBlock().isNull(i)) {
                throw new IllegalArgumentException("Map keys must not be null");
            }
            mapBlock.getRawKeyBlock().writePositionTo(i, this.keyBlockBuilder);
            if (mapBlock.getRawValueBlock().isNull(i)) {
                this.valueBlockBuilder.appendNull();
                continue;
            }
            mapBlock.getRawValueBlock().writePositionTo(i, this.valueBlockBuilder);
        }
        this.closeEntry(mapBlock.getHashTables().get(), startValueOffset * 2);
        return this;
    }

    private int[] getNewHashTables(int newSize) {
        if (this.hashTables.get() != null) {
            return MapBlockBuilder.newNegativeOneFilledArray(newSize * 2);
        }
        return null;
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        int newSize = BlockUtil.calculateBlockResetSize(this.getPositionCount());
        return new MapBlockBuilder(this.keyBlockEquals, this.keyBlockHashCode, blockBuilderStatus, this.keyBlockBuilder.newBlockBuilderLike(blockBuilderStatus), this.valueBlockBuilder.newBlockBuilderLike(blockBuilderStatus), newSize, this.getNewHashTables(newSize));
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        int newSize = Math.max(BlockUtil.calculateBlockResetSize(this.getPositionCount()), expectedEntries);
        int nestedExpectedEntries = BlockUtil.calculateNestedStructureResetSize(this.offsets[this.positionCount], this.positionCount, expectedEntries);
        return new MapBlockBuilder(this.keyBlockEquals, this.keyBlockHashCode, blockBuilderStatus, this.keyBlockBuilder.newBlockBuilderLike(blockBuilderStatus, nestedExpectedEntries), this.valueBlockBuilder.newBlockBuilderLike(blockBuilderStatus, nestedExpectedEntries), newSize, this.getNewHashTables(newSize));
    }

    public void loadHashTables() {
        this.ensureHashTableLoaded(this.keyBlockHashCode);
    }

    @Override
    protected void ensureHashTableLoaded(MethodHandle keyBlockHashCode) {
        if (!this.isHashTablesPresent()) {
            this.hashTables.loadHashTables(this.positionCount, this.offsets, this.mapIsNull, this.keyBlockBuilder, keyBlockHashCode);
        }
    }

    private static int[] newNegativeOneFilledArray(int size) {
        int[] hashTable = new int[size];
        Arrays.fill(hashTable, -1);
        return hashTable;
    }

    static void buildHashTable(Block keyBlock, int keyOffset, int keyCount, MethodHandle keyBlockHashCode, int[] outputHashTable, int hashTableOffset, int hashTableSize) {
        int i = 0;
        while (i < keyCount) {
            int hash = MapBlockBuilder.getHashPosition(keyBlock, keyOffset + i, keyBlockHashCode, hashTableSize);
            while (true) {
                if (outputHashTable[hashTableOffset + hash] == -1) break;
                if (++hash != hashTableSize) continue;
                hash = 0;
            }
            outputHashTable[hashTableOffset + hash] = i++;
        }
    }

    private static void buildHashTableStrict(Block keyBlock, int keyOffset, int keyCount, MethodHandle keyBlockEquals, MethodHandle keyBlockHashCode, int[] outputHashTable, int hashTableOffset, int hashTableSize) throws DuplicateMapKeyException, NotSupportedException {
        int i = 0;
        while (i < keyCount) {
            int hash = MapBlockBuilder.getHashPosition(keyBlock, keyOffset + i, keyBlockHashCode, hashTableSize);
            while (true) {
                Boolean isDuplicateKey;
                if (outputHashTable[hashTableOffset + hash] == -1) break;
                try {
                    isDuplicateKey = keyBlockEquals.invokeExact(keyBlock, keyOffset + i, keyBlock, keyOffset + outputHashTable[hashTableOffset + hash]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                if (isDuplicateKey == null) {
                    throw new NotSupportedException("map key cannot be null or contain nulls");
                }
                if (isDuplicateKey.booleanValue()) {
                    throw new DuplicateMapKeyException(keyBlock, keyOffset + i);
                }
                if (++hash != hashTableSize) continue;
                hash = 0;
            }
            outputHashTable[hashTableOffset + hash] = i++;
        }
    }

    private static int getHashPosition(Block keyBlock, int position, MethodHandle keyBlockHashCode, int hashTableSize) {
        long hashCode;
        if (keyBlock.isNull(position)) {
            throw new IllegalArgumentException("map keys cannot be null");
        }
        try {
            hashCode = keyBlockHashCode.invokeExact(keyBlock, position);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return MapBlockBuilder.computePosition(hashCode, hashTableSize);
    }

    static int computePosition(long hashcode, int hashTableSize) {
        return (int)(Integer.toUnsignedLong(Long.hashCode(hashcode)) * (long)hashTableSize >> 32);
    }

    static void verify(boolean assertion, String message) {
        if (!assertion) {
            throw new AssertionError((Object)message);
        }
    }
}

