/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.presto.common.RuntimeMetric;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RuntimeStats {
    private final ConcurrentMap<String, RuntimeMetric> metrics = new ConcurrentHashMap<String, RuntimeMetric>();

    public RuntimeStats() {
    }

    @JsonCreator
    public RuntimeStats(Map<String, RuntimeMetric> metrics) {
        Objects.requireNonNull(metrics, "metrics is null");
        metrics.forEach((name, newMetric) -> this.metrics.computeIfAbsent((String)name, RuntimeMetric::new).mergeWith((RuntimeMetric)newMetric));
    }

    public static RuntimeStats copyOf(RuntimeStats stats) {
        return new RuntimeStats(stats.getMetrics());
    }

    public static RuntimeStats merge(RuntimeStats stats1, RuntimeStats stats2) {
        if (stats1 == null) {
            return stats2;
        }
        if (stats2 == null) {
            return stats1;
        }
        RuntimeStats mergedStats = RuntimeStats.copyOf(stats1);
        mergedStats.mergeWith(stats2);
        return mergedStats;
    }

    public void reset() {
        this.metrics.clear();
    }

    public RuntimeMetric getMetric(String name) {
        return (RuntimeMetric)this.metrics.get(name);
    }

    @JsonValue
    public Map<String, RuntimeMetric> getMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public void addMetricValue(String name, long value) {
        this.metrics.computeIfAbsent(name, RuntimeMetric::new).addValue(value);
    }

    public void mergeMetric(String name, RuntimeMetric metric) {
        this.metrics.computeIfAbsent(name, RuntimeMetric::new).mergeWith(metric);
    }

    public void mergeWith(RuntimeStats stats) {
        if (stats == null) {
            return;
        }
        stats.getMetrics().forEach((name, newMetric) -> this.metrics.computeIfAbsent((String)name, RuntimeMetric::new).mergeWith((RuntimeMetric)newMetric));
    }

    public void update(RuntimeStats stats) {
        if (stats == null) {
            return;
        }
        stats.getMetrics().forEach((name, newMetric) -> this.metrics.computeIfAbsent((String)name, RuntimeMetric::new).set((RuntimeMetric)newMetric));
    }
}

