/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public final class BlockUtil {
    private static final double BLOCK_RESET_SKEW = 1.25;
    private static final int DEFAULT_CAPACITY = 64;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    private BlockUtil() {
    }

    static void checkArrayRange(int[] array, int offset, int length) {
        Objects.requireNonNull(array, "array is null");
        if (offset < 0 || length < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException(String.format("Invalid offset %s and length %s in array with %s elements", offset, length, array.length));
        }
    }

    static void checkArrayRange(boolean[] array, int offset, int length) {
        Objects.requireNonNull(array, "array is null");
        if (offset < 0 || length < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException(String.format("Invalid offset %s and length %s in array with %s elements", offset, length, array.length));
        }
    }

    static void checkValidRegion(int positionCount, int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid position %s and length %s in block with %s positions", positionOffset, length, positionCount));
        }
    }

    static void checkValidPositions(boolean[] positions, int positionCount) {
        if (positions.length != positionCount) {
            throw new IllegalArgumentException(String.format("Invalid positions array size %d, actual position count is %d", positions.length, positionCount));
        }
    }

    static void checkValidPosition(int position, int positionCount) {
        if (position < 0 || position >= positionCount) {
            throw new IllegalArgumentException(String.format("Invalid position %s in block with %s positions", position, positionCount));
        }
    }

    static int calculateNewArraySize(int currentSize) {
        long newSize = (long)currentSize + (long)(currentSize >> 1);
        if (newSize < 64L) {
            newSize = 64L;
        } else if (newSize > 0x7FFFFFF7L && (newSize = 0x7FFFFFF7L) == (long)currentSize) {
            throw new IllegalArgumentException(String.format("Can not grow array beyond '%s'", 0x7FFFFFF7));
        }
        return (int)newSize;
    }

    static int calculateBlockResetSize(int currentSize) {
        long newSize = (long)Math.ceil((double)currentSize * 1.25);
        if (newSize < 64L) {
            newSize = 64L;
        } else if (newSize > 0x7FFFFFF7L) {
            newSize = 0x7FFFFFF7L;
        }
        return (int)newSize;
    }

    static int calculateNestedStructureResetSize(int currentNestedStructureSize, int currentNestedStructurePositionCount, int expectedPositionCount) {
        long newSize = Math.max((long)Math.ceil((double)currentNestedStructureSize * 1.25), currentNestedStructurePositionCount == 0 ? (long)currentNestedStructureSize : (long)currentNestedStructureSize * (long)expectedPositionCount / (long)currentNestedStructurePositionCount);
        if (newSize > 0x7FFFFFF7L) {
            return 0x7FFFFFF7;
        }
        return Math.toIntExact(newSize);
    }

    static int[] compactOffsets(int[] offsets, int index, int length) {
        if (index == 0 && offsets.length == length + 1) {
            return offsets;
        }
        int[] newOffsets = new int[length + 1];
        for (int i = 1; i <= length; ++i) {
            newOffsets[i] = offsets[index + i] - offsets[index];
        }
        return newOffsets;
    }

    static Slice compactSlice(Slice slice, int index, int length) {
        if (slice.isCompact() && index == 0 && length == slice.length()) {
            return slice;
        }
        return Slices.copyOf((Slice)slice, (int)index, (int)length);
    }

    public static boolean[] compactArray(boolean[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    public static byte[] compactArray(byte[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    public static short[] compactArray(short[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    public static int[] compactArray(int[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    public static long[] compactArray(long[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    static int countUsedPositions(boolean[] positions) {
        int used = 0;
        for (boolean position : positions) {
            if (!position) continue;
            ++used;
        }
        return used;
    }

    static boolean arraySame(Object[] array1, Object[] array2) {
        if (array1 == null || array2 == null || array1.length != array2.length) {
            throw new IllegalArgumentException("array1 and array2 cannot be null and should have same length");
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean internalPositionInRange(int internalPosition, int offset, int positionCount) {
        boolean withinRange;
        boolean bl = withinRange = internalPosition >= offset && internalPosition < positionCount + offset;
        assert (withinRange) : String.format("internalPosition %s is not within range [%s, %s)", internalPosition, offset, positionCount + offset);
        return withinRange;
    }

    static boolean[] appendNullToIsNullArray(@Nullable boolean[] isNull, int offsetBase, int positionCount) {
        int desiredLength = offsetBase + positionCount + 1;
        boolean[] newIsNull = new boolean[desiredLength];
        if (isNull != null) {
            BlockUtil.checkArrayRange(isNull, offsetBase, positionCount);
            System.arraycopy(isNull, 0, newIsNull, 0, desiredLength - 1);
        }
        newIsNull[desiredLength - 1] = true;
        return newIsNull;
    }

    static int[] appendNullToOffsetsArray(int[] offsets, int offsetBase, int positionCount) {
        BlockUtil.checkArrayRange(offsets, offsetBase, positionCount + 1);
        int desiredLength = offsetBase + positionCount + 2;
        int[] newOffsets = Arrays.copyOf(offsets, desiredLength);
        newOffsets[desiredLength - 1] = newOffsets[desiredLength - 2];
        return newOffsets;
    }

    public static byte[] ensureCapacity(byte[] buffer, int capacity) {
        if (buffer == null) {
            buffer = new byte[capacity];
        } else if (buffer.length < capacity) {
            buffer = Arrays.copyOf(buffer, capacity);
        }
        return buffer;
    }

    public static short[] ensureCapacity(short[] buffer, int capacity) {
        if (buffer == null) {
            buffer = new short[capacity];
        } else if (buffer.length < capacity) {
            buffer = Arrays.copyOf(buffer, capacity);
        }
        return buffer;
    }

    public static int[] ensureCapacity(int[] buffer, int capacity) {
        if (buffer == null) {
            buffer = new int[capacity];
        } else if (buffer.length < capacity) {
            buffer = Arrays.copyOf(buffer, capacity);
        }
        return buffer;
    }

    public static long[] ensureCapacity(long[] buffer, int capacity) {
        if (buffer == null) {
            buffer = new long[capacity];
        } else if (buffer.length < capacity) {
            buffer = Arrays.copyOf(buffer, capacity);
        }
        return buffer;
    }

    public static int getNum128Integers(int length) {
        int num128Integers = length / 8 / 2;
        if (num128Integers * 8 * 2 != length) {
            throw new IllegalArgumentException(String.format("length %d must be a multiple of 16.", length));
        }
        return num128Integers;
    }

    static Block[] ensureBlocksAreLoaded(Block[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            Block loaded = blocks[i].getLoadedBlock();
            if (loaded == blocks[i]) continue;
            Block[] loadedBlocks = (Block[])blocks.clone();
            loadedBlocks[i++] = loaded;
            while (i < blocks.length) {
                loadedBlocks[i] = blocks[i].getLoadedBlock();
                ++i;
            }
            return loadedBlocks;
        }
        return blocks;
    }
}

