/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.AbstractVariableWidthBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.BlockUtil;
import com.facebook.presto.common.block.VariableWidthBlock;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.slice.UnsafeSlice;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class VariableWidthBlockBuilder
extends AbstractVariableWidthBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(VariableWidthBlockBuilder.class).instanceSize();
    private BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private int initialEntryCount;
    private int initialSliceOutputSize;
    private SliceOutput sliceOutput = new DynamicSliceOutput(0);
    private boolean hasNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] offsets = new int[1];
    private int positions;
    private int currentEntrySize;
    private long arraysRetainedSizeInBytes;

    public VariableWidthBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytes) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = expectedEntries;
        this.initialSliceOutputSize = Math.min(expectedBytes, 0x7FFFFFF7);
        this.updateArraysDataSize();
    }

    @Override
    public int getPositionOffset(int position) {
        BlockUtil.checkValidPosition(position, this.positions);
        return this.getOffset(position);
    }

    @Override
    public int getSliceLength(int position) {
        BlockUtil.checkValidPosition(position, this.positions);
        return this.getOffset(position + 1) - this.getOffset(position);
    }

    @Override
    public Slice getRawSlice(int position) {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public int getPositionCount() {
        return this.positions;
    }

    @Override
    public long getSizeInBytes() {
        long arraysSizeInBytes = 5L * (long)this.positions;
        return (long)this.sliceOutput.size() + arraysSizeInBytes;
    }

    @Override
    public long getRegionSizeInBytes(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, positionOffset, length);
        long arraysSizeInBytes = 5L * (long)length;
        return (long)(this.getOffset(positionOffset + length) - this.getOffset(positionOffset)) + arraysSizeInBytes;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        BlockUtil.checkValidPositions(positions, this.getPositionCount());
        long sizeInBytes = 0L;
        int usedPositionCount = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i]) continue;
            ++usedPositionCount;
            sizeInBytes += (long)(this.getOffset(i + 1) - this.getOffset(i));
        }
        return sizeInBytes + 5L * (long)usedPositionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.sliceOutput.getRetainedSize() + this.arraysRetainedSizeInBytes;
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.sliceOutput, this.sliceOutput.getRetainedSize());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int finalLength = 0;
        for (int i = offset; i < offset + length; ++i) {
            finalLength += this.getSliceLength(positions[i]);
        }
        SliceOutput newSlice = Slices.allocate((int)finalLength).getOutput();
        int[] newOffsets = new int[length + 1];
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = new boolean[length];
        }
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            if (this.isEntryNull(position)) {
                newValueIsNull[i] = true;
            } else {
                newSlice.writeBytes(this.sliceOutput.getUnderlyingSlice(), this.getPositionOffset(position), this.getSliceLength(position));
            }
            newOffsets[i + 1] = newSlice.size();
        }
        return new VariableWidthBlock(0, length, newSlice.slice(), newOffsets, newValueIsNull);
    }

    @Override
    public BlockBuilder writeByte(int value) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeByte(value);
        ++this.currentEntrySize;
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeShort(value);
        this.currentEntrySize += 2;
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeInt(value);
        this.currentEntrySize += 4;
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeLong(value);
        this.currentEntrySize += 8;
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeBytes(source, sourceIndex, length);
        this.currentEntrySize += length;
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        this.entryAdded(this.currentEntrySize, false);
        this.currentEntrySize = 0;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.hasNullValue = true;
        this.entryAdded(0, true);
        return this;
    }

    private void entryAdded(int bytesWritten, boolean isNull) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        if (this.valueIsNull.length <= this.positions) {
            this.growCapacity();
        }
        this.valueIsNull[this.positions] = isNull;
        this.offsets[this.positions + 1] = this.sliceOutput.size();
        ++this.positions;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5 + bytesWritten);
        }
    }

    private void growCapacity() {
        int newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        this.updateArraysDataSize();
    }

    private void initializeCapacity() {
        if (this.positions != 0 || this.currentEntrySize != 0) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " was used before initialization");
        }
        this.initialized = true;
        this.valueIsNull = new boolean[this.initialEntryCount];
        this.offsets = new int[this.initialEntryCount + 1];
        this.sliceOutput = new DynamicSliceOutput(this.initialSliceOutputSize);
        this.updateArraysDataSize();
    }

    private void updateArraysDataSize() {
        this.arraysRetainedSizeInBytes = SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.offsets);
    }

    @Override
    public BlockBuilder readPositionFrom(SliceInput input) {
        boolean isNull;
        boolean bl = isNull = input.readByte() == 0;
        if (isNull) {
            this.appendNull();
        } else {
            if (!this.initialized) {
                this.initializeCapacity();
            }
            int length = input.readInt();
            try {
                this.sliceOutput.writeBytes((InputStream)input, length);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.currentEntrySize += length;
            this.closeEntry();
        }
        return this;
    }

    @Override
    public boolean mayHaveNull() {
        return this.hasNullValue;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull[position];
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, positionOffset, length);
        return new VariableWidthBlock(positionOffset, length, this.sliceOutput.slice(), this.offsets, this.hasNullValue ? this.valueIsNull : null);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, positionOffset, length);
        int[] newOffsets = BlockUtil.compactOffsets(this.offsets, positionOffset, length);
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = BlockUtil.compactArray(this.valueIsNull, positionOffset, length);
        }
        Slice slice = BlockUtil.compactSlice(this.sliceOutput.getUnderlyingSlice(), this.offsets[positionOffset], newOffsets[length]);
        return new VariableWidthBlock(0, length, slice, newOffsets, newValueIsNull);
    }

    @Override
    public Block build() {
        if (this.currentEntrySize > 0) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return new VariableWidthBlock(0, this.positions, this.sliceOutput.slice(), this.offsets, this.hasNullValue ? this.valueIsNull : null);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        int currentSizeInBytes = this.positions == 0 ? this.positions : this.getOffset(this.positions) - this.getOffset(0);
        return new VariableWidthBlockBuilder(blockBuilderStatus, BlockUtil.calculateBlockResetSize(this.positions), BlockUtil.calculateBlockResetSize(currentSizeInBytes));
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        int newSize = Math.max(BlockUtil.calculateBlockResetSize(this.positions), expectedEntries);
        int currentSizeInBytes = this.offsets[this.positions];
        return new VariableWidthBlockBuilder(blockBuilderStatus, newSize, BlockUtil.calculateNestedStructureResetSize(currentSizeInBytes, this.positions, newSize));
    }

    private int getOffset(int position) {
        return this.offsets[position];
    }

    public String toString() {
        return String.format("VariableWidthBlockBuilder(%d){positionCount=%d,size=%d}", this.hashCode(), this.getPositionCount(), this.sliceOutput.size());
    }

    @Override
    public byte getByteUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return UnsafeSlice.getByteUnchecked((Slice)this.getRawSlice(internalPosition), (int)this.offsets[internalPosition]);
    }

    @Override
    public short getShortUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return UnsafeSlice.getShortUnchecked((Slice)this.getRawSlice(internalPosition), (int)this.offsets[internalPosition]);
    }

    @Override
    public int getIntUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return UnsafeSlice.getIntUnchecked((Slice)this.getRawSlice(internalPosition), (int)this.offsets[internalPosition]);
    }

    @Override
    public long getLongUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return UnsafeSlice.getLongUnchecked((Slice)this.getRawSlice(internalPosition), (int)this.offsets[internalPosition]);
    }

    @Override
    public long getLongUnchecked(int internalPosition, int offset) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return UnsafeSlice.getLongUnchecked((Slice)this.getRawSlice(internalPosition), (int)(this.offsets[internalPosition] + offset));
    }

    @Override
    public Slice getSliceUnchecked(int internalPosition, int offset, int length) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.getRawSlice(internalPosition).slice(this.offsets[internalPosition] + offset, length);
    }

    @Override
    public int getSliceLengthUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.offsets[internalPosition + 1] - this.offsets[internalPosition];
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.valueIsNull[internalPosition];
    }

    @Override
    public int getOffsetBase() {
        return 0;
    }
}

