/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.QualifiedObjectName;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class TypeSignatureBase {
    private final Optional<String> standardTypeBase;
    private final Optional<QualifiedObjectName> typeBase;

    public static TypeSignatureBase of(String name) {
        if (name.chars().noneMatch(c -> c == 46)) {
            return new TypeSignatureBase(name);
        }
        return new TypeSignatureBase(QualifiedObjectName.valueOf(name.toLowerCase(Locale.ENGLISH)));
    }

    public static TypeSignatureBase of(QualifiedObjectName name) {
        return new TypeSignatureBase(name);
    }

    private TypeSignatureBase(String standardTypeBase) {
        TypeSignatureBase.checkArgument(standardTypeBase != null, "standardTypeBase is null", new Object[0]);
        TypeSignatureBase.checkArgument(!standardTypeBase.isEmpty(), "standardTypeBase is empty", new Object[0]);
        TypeSignatureBase.checkArgument(standardTypeBase.chars().noneMatch(c -> c == 46), "Standard type %s should not have '.' in it", standardTypeBase);
        TypeSignatureBase.checkArgument(TypeSignatureBase.validateName(standardTypeBase), "Bad characters in base type: %s", standardTypeBase);
        this.standardTypeBase = Optional.of(standardTypeBase);
        this.typeBase = Optional.empty();
    }

    private TypeSignatureBase(QualifiedObjectName typeBase) {
        TypeSignatureBase.checkArgument(typeBase != null, "typeBase is null", new Object[0]);
        TypeSignatureBase.checkArgument(TypeSignatureBase.validateName(typeBase.getObjectName()), "Bad characters in base type: %s", typeBase);
        this.standardTypeBase = Optional.empty();
        this.typeBase = Optional.of(typeBase);
    }

    public boolean isStandardType() {
        return this.standardTypeBase.isPresent();
    }

    public QualifiedObjectName getQualifiedObjectName() {
        TypeSignatureBase.checkArgument(this.typeBase.isPresent(), "TypeSignatureBase %s is not a QualifiedObjectName", this.toString());
        return this.typeBase.get();
    }

    private static boolean validateName(String name) {
        return name.chars().noneMatch(c -> c == 60 || c == 62 || c == 44);
    }

    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeSignatureBase other = (TypeSignatureBase)obj;
        return Objects.equals(this.standardTypeBase.map(s -> s.toLowerCase(Locale.ENGLISH)), other.standardTypeBase.map(s -> s.toLowerCase(Locale.ENGLISH))) && Objects.equals(this.typeBase, other.typeBase);
    }

    public int hashCode() {
        return Objects.hash(this.standardTypeBase.map(s -> s.toLowerCase(Locale.ENGLISH)), this.typeBase);
    }

    public String toString() {
        return this.standardTypeBase.orElseGet(() -> this.typeBase.get().toString());
    }
}

