/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockUtil;
import com.facebook.presto.common.block.IntArrayList;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.SingleRowBlock;
import io.airlift.slice.SliceOutput;

public abstract class AbstractRowBlock
implements Block {
    protected final int numFields;

    protected abstract Block[] getRawFieldBlocks();

    protected abstract int[] getFieldBlockOffsets();

    @Override
    public abstract int getOffsetBase();

    protected abstract boolean[] getRowIsNull();

    protected int getFieldBlockOffset(int position) {
        return this.getFieldBlockOffsets()[position + this.getOffsetBase()];
    }

    protected AbstractRowBlock(int numFields) {
        if (numFields <= 0) {
            throw new IllegalArgumentException("Number of fields in RowBlock must be positive");
        }
        this.numFields = numFields;
    }

    @Override
    public String getEncodingName() {
        return "ROW";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        boolean[] newRowIsNull = new boolean[length];
        IntArrayList fieldBlockPositions = new IntArrayList(length);
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            if (this.isNull(position)) {
                newRowIsNull[i] = true;
                newOffsets[i + 1] = newOffsets[i];
                continue;
            }
            newOffsets[i + 1] = newOffsets[i] + 1;
            fieldBlockPositions.add(this.getFieldBlockOffset(position));
        }
        Block[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.getRawFieldBlocks()[i].copyPositions(fieldBlockPositions.elements(), 0, fieldBlockPositions.size());
        }
        return RowBlock.createRowBlockInternal(0, length, newRowIsNull, newOffsets, newBlocks);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return RowBlock.createRowBlockInternal(position + this.getOffsetBase(), length, this.getRowIsNull(), this.getFieldBlockOffsets(), this.getRawFieldBlocks());
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        long regionSizeInBytes = 5L * (long)length;
        for (int i = 0; i < this.numFields; ++i) {
            regionSizeInBytes += this.getRawFieldBlocks()[i].getRegionSizeInBytes(startFieldBlockOffset, fieldBlockLength);
        }
        return regionSizeInBytes;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        BlockUtil.checkValidPositions(positions, this.getPositionCount());
        int usedPositionCount = 0;
        boolean[] fieldPositions = new boolean[this.getRawFieldBlocks()[0].getPositionCount()];
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i]) continue;
            ++usedPositionCount;
            int startFieldBlockOffset = this.getFieldBlockOffset(i);
            int endFieldBlockOffset = this.getFieldBlockOffset(i + 1);
            for (int j = startFieldBlockOffset; j < endFieldBlockOffset; ++j) {
                fieldPositions[j] = true;
            }
        }
        long sizeInBytes = 0L;
        for (int j = 0; j < this.numFields; ++j) {
            sizeInBytes += this.getRawFieldBlocks()[j].getPositionsSizeInBytes(fieldPositions);
        }
        return sizeInBytes + 5L * (long)usedPositionCount;
    }

    @Override
    public Block copyRegion(int position, int length) {
        boolean[] newRowIsNull;
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        Object[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.getRawFieldBlocks()[i].copyRegion(startFieldBlockOffset, fieldBlockLength);
        }
        int[] newOffsets = BlockUtil.compactOffsets(this.getFieldBlockOffsets(), position + this.getOffsetBase(), length);
        boolean[] rowIsNull = this.getRowIsNull();
        boolean[] blArray = newRowIsNull = rowIsNull == null ? null : BlockUtil.compactArray(rowIsNull, position + this.getOffsetBase(), length);
        if (BlockUtil.arraySame(newBlocks, this.getRawFieldBlocks()) && newOffsets == this.getFieldBlockOffsets() && newRowIsNull == rowIsNull) {
            return this;
        }
        return RowBlock.createRowBlockInternal(0, length, newRowIsNull, newOffsets, (Block[])newBlocks);
    }

    @Override
    public Block getBlock(int position) {
        this.checkReadablePosition(position);
        return new SingleRowBlock(this.getFieldBlockOffset(position), this.getRawFieldBlocks());
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.appendStructureInternal(this, position);
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if (this.isNull(position)) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            int fieldBlockOffset = this.getFieldBlockOffset(position);
            Block[] fieldBlocks = this.getRawFieldBlocks();
            for (int i = 0; i < this.numFields; ++i) {
                fieldBlocks[i].writePositionTo(fieldBlockOffset, output);
            }
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + 1);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        Block[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.getRawFieldBlocks()[i].copyRegion(startFieldBlockOffset, fieldBlockLength);
        }
        boolean[] newRowIsNull = new boolean[]{this.isNull(position)};
        int[] newOffsets = new int[]{0, fieldBlockLength};
        return RowBlock.createRowBlockInternal(0, 1, newRowIsNull, newOffsets, newBlocks);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return 0L;
        }
        Block[] rawFieldBlocks = this.getRawFieldBlocks();
        long size = 0L;
        for (int i = 0; i < this.numFields; ++i) {
            size += rawFieldBlocks[i].getEstimatedDataSizeForStats(this.getFieldBlockOffset(position));
        }
        return size;
    }

    @Override
    public boolean mayHaveNull() {
        return this.getRowIsNull() != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        boolean[] rowIsNull = this.getRowIsNull();
        return rowIsNull != null && rowIsNull[position + this.getOffsetBase()];
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    @Override
    public Block getBlockUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return new SingleRowBlock(this.getFieldBlockOffsets()[internalPosition], this.getRawFieldBlocks());
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.getRowIsNull()[internalPosition];
    }

    @Override
    public Block appendNull() {
        boolean[] rowIsNull = BlockUtil.appendNullToIsNullArray(this.getRowIsNull(), this.getOffsetBase(), this.getPositionCount());
        int[] offsets = BlockUtil.appendNullToOffsetsArray(this.getFieldBlockOffsets(), this.getOffsetBase(), this.getPositionCount());
        return RowBlock.createRowBlockInternal(this.getOffsetBase(), this.getPositionCount() + 1, rowIsNull, offsets, this.getRawFieldBlocks());
    }
}

