/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.AbstractMapBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import io.airlift.slice.SizeOf;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class MapBlock
extends AbstractMapBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapBlock.class).instanceSize();
    private final int startOffset;
    private final int positionCount;
    private final boolean[] mapIsNull;
    private final int[] offsets;
    private final Block keyBlock;
    private final Block valueBlock;
    private AbstractMapBlock.HashTables hashTables;
    private volatile long sizeInBytes;
    private final long retainedSizeInBytes;

    public static MapBlock fromKeyValueBlock(int positionCount, Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, MapType mapType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode, MethodHandle keyBlockHashCode) {
        MapBlock.validateConstructorArguments(0, positionCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock, mapType.getKeyType(), keyBlockNativeEquals, keyNativeHashCode);
        return MapBlock.createMapBlockInternal(0, positionCount, mapIsNull, offsets, keyBlock, valueBlock, new AbstractMapBlock.HashTables(Optional.empty(), positionCount, keyBlock.getPositionCount() * 2), mapType.getKeyType(), keyBlockNativeEquals, keyNativeHashCode, keyBlockHashCode);
    }

    public static MapBlock createMapBlockInternal(int startOffset, int positionCount, Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, AbstractMapBlock.HashTables hashTables, Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode, MethodHandle keyBlockHashCode) {
        MapBlock.validateConstructorArguments(startOffset, positionCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock, keyType, keyBlockNativeEquals, keyNativeHashCode);
        Objects.requireNonNull(hashTables, "hashTables is null");
        return new MapBlock(startOffset, positionCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock, hashTables, keyType, keyBlockNativeEquals, keyNativeHashCode, keyBlockHashCode);
    }

    private static void validateConstructorArguments(int startOffset, int positionCount, @Nullable boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("startOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (mapIsNull != null && mapIsNull.length - startOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        Objects.requireNonNull(offsets, "offsets is null");
        if (offsets.length - startOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        Objects.requireNonNull(keyBlock, "keyBlock is null");
        Objects.requireNonNull(valueBlock, "valueBlock is null");
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("keyBlock and valueBlock has different size: %s %s", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(keyBlockNativeEquals, "keyBlockNativeEquals is null");
        Objects.requireNonNull(keyNativeHashCode, "keyNativeHashCode is null");
    }

    private MapBlock(int startOffset, int positionCount, @Nullable boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, AbstractMapBlock.HashTables hashTables, Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode, MethodHandle keyBlockHashCode) {
        super(keyType, keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
        int[] rawHashTables = hashTables.get().orElse(null);
        if (rawHashTables != null && rawHashTables.length < keyBlock.getPositionCount() * 2) {
            throw new IllegalArgumentException(String.format("keyBlock/valueBlock size does not match hash table size: %s %s", keyBlock.getPositionCount(), rawHashTables.length));
        }
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.mapIsNull = mapIsNull;
        this.offsets = offsets;
        this.keyBlock = keyBlock;
        this.valueBlock = valueBlock;
        this.hashTables = hashTables;
        this.sizeInBytes = -1L;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + keyBlock.getRetainedSizeInBytes() + valueBlock.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])offsets) + SizeOf.sizeOf((boolean[])mapIsNull) + hashTables.getRetainedSizeInBytes();
    }

    @Override
    protected Block getRawKeyBlock() {
        return this.keyBlock;
    }

    @Override
    protected Block getRawValueBlock() {
        return this.valueBlock;
    }

    @Override
    protected AbstractMapBlock.HashTables getHashTables() {
        return this.hashTables;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    public int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    @Nullable
    protected boolean[] getMapIsNull() {
        return this.mapIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes < 0L) {
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    private void calculateSize() {
        int entriesStart = this.offsets[this.startOffset];
        int entriesEnd = this.offsets[this.startOffset + this.positionCount];
        int entryCount = entriesEnd - entriesStart;
        this.sizeInBytes = this.keyBlock.getRegionSizeInBytes(entriesStart, entryCount) + this.valueBlock.getRegionSizeInBytes(entriesStart, entryCount) + 5L * (long)this.positionCount + 8L * (long)entryCount + this.hashTables.getInstanceSizeInBytes();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.keyBlock, this.keyBlock.getRetainedSizeInBytes());
        consumer.accept(this.valueBlock, this.valueBlock.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        consumer.accept(this.mapIsNull, SizeOf.sizeOf((boolean[])this.mapIsNull));
        consumer.accept(this.hashTables, this.hashTables.getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MapBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Block getLoadedBlock() {
        if (this.keyBlock != this.keyBlock.getLoadedBlock()) {
            throw new IllegalStateException();
        }
        Block loadedValueBlock = this.valueBlock.getLoadedBlock();
        if (loadedValueBlock == this.valueBlock) {
            return this;
        }
        return MapBlock.createMapBlockInternal(this.startOffset, this.positionCount, Optional.ofNullable(this.mapIsNull), this.offsets, this.keyBlock, loadedValueBlock, this.hashTables, this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureHashTableLoaded() {
        if (this.hashTables.get().isPresent()) {
            return;
        }
        AbstractMapBlock.HashTables hashTables = this.hashTables;
        synchronized (hashTables) {
            if (this.hashTables.get().isPresent()) {
                return;
            }
            int[] hashTables2 = new int[this.getRawKeyBlock().getPositionCount() * 2];
            Arrays.fill(hashTables2, -1);
            MapBlockBuilder.verify(this.hashTables.getExpectedHashTableCount() <= this.offsets.length, "incorrect offsets size");
            for (int i = 0; i < this.hashTables.getExpectedHashTableCount(); ++i) {
                int keyOffset = this.offsets[i];
                int keyCount = this.offsets[i + 1] - keyOffset;
                if (keyCount < 0) {
                    throw new IllegalArgumentException(String.format("Offset is not monotonically ascending. offsets[%s]=%s, offsets[%s]=%s", i, this.offsets[i], i + 1, this.offsets[i + 1]));
                }
                if (this.mapIsNull != null && this.mapIsNull[i] && keyCount != 0) {
                    throw new IllegalArgumentException("A null map must have zero entries");
                }
                MapBlockBuilder.buildHashTable(this.getRawKeyBlock(), keyOffset, keyCount, this.keyBlockHashCode, hashTables2, keyOffset * 2, keyCount * 2);
            }
            this.hashTables.set(hashTables2);
        }
    }
}

