/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class TypeSignature {
    private final String base;
    private final List<TypeSignature> parameters;

    private TypeSignature(String base, List<TypeSignature> parameters) {
        this.base = (String)Preconditions.checkNotNull((Object)base, (Object)"base is null");
        Preconditions.checkArgument((!base.isEmpty() ? 1 : 0) != 0, (Object)"base is empty");
        Preconditions.checkArgument((!Pattern.matches(".*[<>,].*", base) ? 1 : 0) != 0, (String)"Bad characters in base type: %s", (Object[])new Object[]{base});
        this.parameters = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(parameters, (Object)"parameters is null")));
    }

    @JsonValue
    public String toString() {
        String typeName = this.base;
        if (!this.parameters.isEmpty()) {
            typeName = typeName + "<" + Joiner.on((String)",").join(this.parameters) + ">";
        }
        return typeName;
    }

    @JsonProperty
    public String getBase() {
        return this.base;
    }

    @JsonProperty
    public List<TypeSignature> getParameters() {
        return this.parameters;
    }

    @JsonCreator
    public static TypeSignature parseTypeSignature(String signature) {
        if (!signature.contains("<")) {
            return new TypeSignature(signature, (List<TypeSignature>)ImmutableList.of());
        }
        String baseName = null;
        ArrayList<TypeSignature> parameters = new ArrayList<TypeSignature>();
        int parameterStart = -1;
        int bracketCount = 0;
        for (int i = 0; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (c == '<') {
                if (bracketCount == 0) {
                    Preconditions.checkState((baseName == null ? 1 : 0) != 0, (Object)"Expected baseName to be null");
                    Preconditions.checkState((parameterStart == -1 ? 1 : 0) != 0, (Object)"Expected parameter start to be -1");
                    baseName = signature.substring(0, i);
                    parameterStart = i + 1;
                }
                ++bracketCount;
                continue;
            }
            if (c == '>') {
                Preconditions.checkArgument((--bracketCount >= 0 ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object[])new Object[]{signature});
                if (bracketCount != 0) continue;
                Preconditions.checkArgument((i == signature.length() - 1 ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object[])new Object[]{signature});
                Preconditions.checkArgument((parameterStart >= 0 ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object[])new Object[]{signature});
                parameters.add(TypeSignature.parseTypeSignature(signature.substring(parameterStart, i)));
                return new TypeSignature(baseName, parameters);
            }
            if (c != ',' || bracketCount != 1) continue;
            Preconditions.checkArgument((parameterStart >= 0 ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object[])new Object[]{signature});
            parameters.add(TypeSignature.parseTypeSignature(signature.substring(parameterStart, i)));
            parameterStart = i + 1;
        }
        throw new IllegalArgumentException(String.format("Bad type signature: '%s'", signature));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSignature other = (TypeSignature)o;
        return Objects.equals(this.base, other.base) && Objects.equals(this.parameters, other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.parameters);
    }
}

