/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client.auth.external;

import com.facebook.presto.client.auth.external.RedirectException;
import com.facebook.presto.client.auth.external.RedirectHandler;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class SystemOpenRedirectHandler
implements RedirectHandler {
    private static final List<String> LINUX_BROWSERS = ImmutableList.of((Object)"xdg-open", (Object)"gnome-open", (Object)"kde-open", (Object)"chromium", (Object)"google", (Object)"google-chrome", (Object)"firefox", (Object)"mozilla", (Object)"opera", (Object)"epiphany", (Object)"konqueror");
    private static final String MACOS_OPEN_COMMAND = "open";
    private static final String WINDOWS_OPEN_COMMAND = "rundll32 url.dll,FileProtocolHandler";
    private static final Splitter SPLITTER = Splitter.on((String)":").omitEmptyStrings().trimResults();

    @Override
    public void redirectTo(URI uri) throws RedirectException {
        String operatingSystem = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        try {
            if (operatingSystem.contains("mac")) {
                SystemOpenRedirectHandler.exec(uri, MACOS_OPEN_COMMAND);
            } else if (operatingSystem.contains("windows")) {
                SystemOpenRedirectHandler.exec(uri, WINDOWS_OPEN_COMMAND);
            } else {
                String executablePath = SystemOpenRedirectHandler.findLinuxBrowser().orElseThrow(() -> new FileNotFoundException("Could not find any known linux browser in $PATH"));
                SystemOpenRedirectHandler.exec(uri, executablePath);
            }
        }
        catch (IOException e) {
            throw new RedirectException(String.format("Could not open uri %s", uri), e);
        }
    }

    private static Optional<String> findLinuxBrowser() {
        List paths = SPLITTER.splitToList((CharSequence)System.getenv("PATH"));
        for (String path : paths) {
            File[] found = Paths.get(path, new String[0]).toFile().listFiles((dir, name) -> LINUX_BROWSERS.contains(name));
            if (found == null || found.length <= 0) continue;
            return Optional.of(found[0].getPath());
        }
        return Optional.empty();
    }

    private static void exec(URI uri, String openCommand) throws IOException {
        Runtime.getRuntime().exec(openCommand + " " + uri.toString());
    }
}

