/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.client.ClientException;
import com.facebook.presto.client.GCSOAuthScope;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class GCSOAuthInterceptor
implements Interceptor {
    public static final String GCS_CREDENTIALS_PATH_KEY = "hive.gcs.credentials.path";
    public static final String GCS_OAUTH_SCOPES_KEY = "hive.gcs.oauth.scopes";
    private static final String GCS_CREDENTIALS_OAUTH_TOKEN_KEY = "hive.gcs.oauth";
    private static final Splitter SCOPE_SPLITTER = Splitter.on((String)"|");
    private final Collection<String> gcsOAuthScopeURLs;
    private final String credentialsFilePath;
    private GoogleCredentials credentials;

    public GCSOAuthInterceptor(String credentialPath, Optional<String> gcsOAuthScopesString) {
        this.credentialsFilePath = Objects.requireNonNull(credentialPath);
        this.gcsOAuthScopeURLs = this.mapScopeStringToURLs(Objects.requireNonNull(gcsOAuthScopesString).orElse(GCSOAuthScope.DEVSTORAGE_READ_ONLY.name()));
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return chain.proceed(this.attachGCSAccessToken(chain.request()));
    }

    private Request attachGCSAccessToken(Request request) {
        AccessToken token = this.getCredentials().getAccessToken();
        return request.newBuilder().addHeader("X-Presto-Extra-Credential", "hive.gcs.oauth=" + token.getTokenValue()).build();
    }

    private synchronized GoogleCredentials getCredentials() {
        if (this.credentials == null) {
            this.credentials = this.createCredentials();
        }
        try {
            this.credentials.refreshIfExpired();
        }
        catch (IOException e) {
            throw new ClientException("Google credential refreshing error", e);
        }
        return this.credentials;
    }

    private GoogleCredentials createCredentials() {
        GoogleCredentials googleCredentials;
        block8: {
            InputStream is = Files.newInputStream(Paths.get(this.credentialsFilePath, new String[0]), new OpenOption[0]);
            try {
                googleCredentials = GoogleCredentials.fromStream((InputStream)is).createScoped(this.gcsOAuthScopeURLs);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClientException("Google credential loading error", e);
                }
            }
            is.close();
        }
        return googleCredentials;
    }

    private Collection<String> mapScopeStringToURLs(String gcsOAuthScopesString) {
        return StreamSupport.stream(SCOPE_SPLITTER.split((CharSequence)gcsOAuthScopesString).spliterator(), false).map(GCSOAuthScope::valueOf).map(scope -> scope.getScopeURL()).collect(Collectors.toList());
    }
}

