/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;

@Immutable
@ThriftStruct
public class ErrorLocation {
    private final int lineNumber;
    private final int columnNumber;

    @JsonCreator
    @ThriftConstructor
    public ErrorLocation(@JsonProperty(value="lineNumber") int lineNumber, @JsonProperty(value="columnNumber") int columnNumber) {
        Preconditions.checkArgument((lineNumber >= 1 ? 1 : 0) != 0, (Object)"lineNumber must be at least one");
        Preconditions.checkArgument((columnNumber >= 1 ? 1 : 0) != 0, (Object)"columnNumber must be at least one");
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    @JsonProperty
    @ThriftField(value=1)
    public int getLineNumber() {
        return this.lineNumber;
    }

    @JsonProperty
    @ThriftField(value=2)
    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lineNumber", this.lineNumber).add("columnNumber", this.columnNumber).toString();
    }
}

