/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.google.common.base.MoreObjects;
import io.airlift.json.JsonCodec;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class JsonResponse<T> {
    private final int statusCode;
    private final String statusMessage;
    private final Headers headers;
    private final String responseBody;
    private final boolean hasValue;
    private final T value;
    private final IllegalArgumentException exception;

    private JsonResponse(int statusCode, String statusMessage, Headers headers, String responseBody) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = Objects.requireNonNull(headers, "headers is null");
        this.responseBody = Objects.requireNonNull(responseBody, "responseBody is null");
        this.hasValue = false;
        this.value = null;
        this.exception = null;
    }

    private JsonResponse(int statusCode, String statusMessage, Headers headers, String responseBody, JsonCodec<T> jsonCodec) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = Objects.requireNonNull(headers, "headers is null");
        this.responseBody = Objects.requireNonNull(responseBody, "responseBody is null");
        Object value = null;
        IllegalArgumentException exception = null;
        try {
            value = jsonCodec.fromJson(responseBody);
        }
        catch (IllegalArgumentException e) {
            exception = new IllegalArgumentException(String.format("Unable to create %s from JSON response:\n[%s]", jsonCodec.getType(), responseBody), e);
        }
        this.hasValue = exception == null;
        this.value = value;
        this.exception = exception;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public T getValue() {
        if (!this.hasValue) {
            throw new IllegalStateException("Response does not contain a JSON value", this.exception);
        }
        return this.value;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    @Nullable
    public IllegalArgumentException getException() {
        return this.exception;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statusCode", this.statusCode).add("statusMessage", (Object)this.statusMessage).add("headers", (Object)this.headers.toMultimap()).add("hasValue", this.hasValue).add("value", this.value).omitNullValues().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> JsonResponse<T> execute(JsonCodec<T> codec, OkHttpClient client, Request request) {
        try (Response response = client.newCall(request).execute();){
            String location;
            if ((response.code() == 307 || response.code() == 308) && (location = response.header("Location")) != null) {
                request = request.newBuilder().url(location).build();
                JsonResponse<T> jsonResponse = JsonResponse.execute(codec, client, request);
                return jsonResponse;
            }
            ResponseBody responseBody = Objects.requireNonNull(response.body());
            String body = responseBody.string();
            if (JsonResponse.isJson(responseBody.contentType())) {
                JsonResponse<T> jsonResponse = new JsonResponse<T>(response.code(), response.message(), response.headers(), body, codec);
                return jsonResponse;
            }
            JsonResponse<T> jsonResponse = new JsonResponse<T>(response.code(), response.message(), response.headers(), body);
            return jsonResponse;
        }
        catch (IOException e) {
            if (!(e instanceof InterruptedIOException)) throw new UncheckedIOException(e);
            if (!"thread interrupted".equals(e.getMessage())) throw new UncheckedIOException(e);
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isJson(MediaType type) {
        return type != null && "application".equals(type.type()) && "json".equals(type.subtype());
    }
}

