/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StatementClient
implements Closeable {
    private static final Splitter SESSION_HEADER_SPLITTER = Splitter.on((char)'=').limit(2).trimResults();
    private static final String USER_AGENT_VALUE = StatementClient.class.getSimpleName() + "/" + (String)MoreObjects.firstNonNull((Object)StatementClient.class.getPackage().getImplementationVersion(), (Object)"unknown");
    private final HttpClient httpClient;
    private final FullJsonResponseHandler<QueryResults> responseHandler;
    private final boolean debug;
    private final String query;
    private final AtomicReference<QueryResults> currentResults = new AtomicReference();
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final Map<String, String> addedPreparedStatements = new ConcurrentHashMap<String, String>();
    private final Set<String> deallocatedPreparedStatements = Sets.newConcurrentHashSet();
    private final AtomicReference<String> startedtransactionId = new AtomicReference();
    private final AtomicBoolean clearTransactionId = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean gone = new AtomicBoolean();
    private final AtomicBoolean valid = new AtomicBoolean(true);
    private final String timeZoneId;
    private final long requestTimeoutNanos;
    private final String user;

    public StatementClient(HttpClient httpClient, JsonCodec<QueryResults> queryResultsCodec, ClientSession session, String query) {
        Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(queryResultsCodec, "queryResultsCodec is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(query, "query is null");
        this.httpClient = httpClient;
        this.responseHandler = FullJsonResponseHandler.createFullJsonResponseHandler(queryResultsCodec);
        this.debug = session.isDebug();
        this.timeZoneId = session.getTimeZoneId();
        this.query = query;
        this.requestTimeoutNanos = session.getClientRequestTimeout().roundTo(TimeUnit.NANOSECONDS);
        this.user = session.getUser();
        Request request = this.buildQueryRequest(session, query);
        FullJsonResponseHandler.JsonResponse response = (FullJsonResponseHandler.JsonResponse)httpClient.execute(request, this.responseHandler);
        if (response.getStatusCode() != HttpStatus.OK.code() || !response.hasValue()) {
            throw this.requestFailedException("starting query", request, (FullJsonResponseHandler.JsonResponse<QueryResults>)response);
        }
        this.processResponse((FullJsonResponseHandler.JsonResponse<QueryResults>)response);
    }

    private Request buildQueryRequest(ClientSession session, String query) {
        Request.Builder builder = this.prepareRequest(Request.Builder.preparePost(), HttpUriBuilder.uriBuilderFrom((URI)session.getServer()).replacePath("/v1/statement").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)query, (Charset)StandardCharsets.UTF_8));
        if (session.getSource() != null) {
            builder.setHeader("X-Presto-Source", session.getSource());
        }
        if (session.getCatalog() != null) {
            builder.setHeader("X-Presto-Catalog", session.getCatalog());
        }
        if (session.getSchema() != null) {
            builder.setHeader("X-Presto-Schema", session.getSchema());
        }
        builder.setHeader("X-Presto-Time-Zone", session.getTimeZoneId());
        if (session.getLocale() != null) {
            builder.setHeader("X-Presto-Language", session.getLocale().toLanguageTag());
        }
        Map<String, String> property = session.getProperties();
        for (Map.Entry<String, String> entry : property.entrySet()) {
            builder.addHeader("X-Presto-Session", entry.getKey() + "=" + entry.getValue());
        }
        Map<String, String> statements = session.getPreparedStatements();
        for (Map.Entry<String, String> entry : statements.entrySet()) {
            builder.addHeader("X-Presto-Prepared-Statement", StatementClient.urlEncode(entry.getKey()) + "=" + StatementClient.urlEncode(entry.getValue()));
        }
        builder.setHeader("X-Presto-Transaction-Id", session.getTransactionId() == null ? "NONE" : session.getTransactionId());
        return builder.build();
    }

    public String getQuery() {
        return this.query;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isGone() {
        return this.gone.get();
    }

    public boolean isFailed() {
        return this.currentResults.get().getError() != null;
    }

    public StatementStats getStats() {
        return this.currentResults.get().getStats();
    }

    public QueryResults current() {
        Preconditions.checkState((boolean)this.isValid(), (Object)"current position is not valid (cursor past end)");
        return this.currentResults.get();
    }

    public QueryResults finalResults() {
        Preconditions.checkState((!this.isValid() || this.isFailed() ? 1 : 0) != 0, (Object)"current position is still valid");
        return this.currentResults.get();
    }

    public Map<String, String> getSetSessionProperties() {
        return ImmutableMap.copyOf(this.setSessionProperties);
    }

    public Set<String> getResetSessionProperties() {
        return ImmutableSet.copyOf(this.resetSessionProperties);
    }

    public Map<String, String> getAddedPreparedStatements() {
        return ImmutableMap.copyOf(this.addedPreparedStatements);
    }

    public Set<String> getDeallocatedPreparedStatements() {
        return ImmutableSet.copyOf(this.deallocatedPreparedStatements);
    }

    public String getStartedtransactionId() {
        return this.startedtransactionId.get();
    }

    public boolean isClearTransactionId() {
        return this.clearTransactionId.get();
    }

    public boolean isValid() {
        return this.valid.get() && !this.isGone() && !this.isClosed();
    }

    private Request.Builder prepareRequest(Request.Builder builder, URI nextUri) {
        builder.setHeader("X-Presto-User", this.user);
        builder.setHeader("User-Agent", USER_AGENT_VALUE).setUri(nextUri);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean advance() {
        URI nextUri = this.current().getNextUri();
        if (this.isClosed() || nextUri == null) {
            this.valid.set(false);
            return false;
        }
        Request request = this.prepareRequest(Request.Builder.prepareGet(), nextUri).build();
        RuntimeException cause = null;
        long start = System.nanoTime();
        long attempts = 0L;
        do {
            FullJsonResponseHandler.JsonResponse response;
            if (attempts > 0L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(attempts * 100L);
                }
                catch (InterruptedException e) {
                    try {
                        this.close();
                    }
                    finally {
                        Thread.currentThread().interrupt();
                    }
                    throw new RuntimeException("StatementClient thread was interrupted");
                }
            }
            ++attempts;
            try {
                response = (FullJsonResponseHandler.JsonResponse)this.httpClient.execute(request, this.responseHandler);
            }
            catch (RuntimeException e) {
                cause = e;
                continue;
            }
            if (response.getStatusCode() == HttpStatus.OK.code() && response.hasValue()) {
                this.processResponse((FullJsonResponseHandler.JsonResponse<QueryResults>)response);
                return true;
            }
            if (response.getStatusCode() == HttpStatus.SERVICE_UNAVAILABLE.code()) continue;
            throw this.requestFailedException("fetching next", request, (FullJsonResponseHandler.JsonResponse<QueryResults>)response);
        } while (System.nanoTime() - start < this.requestTimeoutNanos && !this.isClosed());
        this.gone.set(true);
        throw new RuntimeException("Error fetching next", cause);
    }

    private void processResponse(FullJsonResponseHandler.JsonResponse<QueryResults> response) {
        List keyValue;
        for (String setSession : response.getHeaders("X-Presto-Set-Session")) {
            keyValue = SESSION_HEADER_SPLITTER.splitToList((CharSequence)setSession);
            if (keyValue.size() != 2) continue;
            this.setSessionProperties.put((String)keyValue.get(0), keyValue.size() > 1 ? (String)keyValue.get(1) : "");
        }
        for (String clearSession : response.getHeaders("X-Presto-Clear-Session")) {
            this.resetSessionProperties.add(clearSession);
        }
        for (String entry : response.getHeaders("X-Presto-Added-Prepare")) {
            keyValue = SESSION_HEADER_SPLITTER.splitToList((CharSequence)entry);
            if (keyValue.size() != 2) continue;
            this.addedPreparedStatements.put(StatementClient.urlDecode((String)keyValue.get(0)), StatementClient.urlDecode((String)keyValue.get(1)));
        }
        for (String entry : response.getHeaders("X-Presto-Deallocated-Prepare")) {
            this.deallocatedPreparedStatements.add(StatementClient.urlDecode(entry));
        }
        String startedTransactionId = response.getHeader("X-Presto-Started-Transaction-Id");
        if (startedTransactionId != null) {
            this.startedtransactionId.set(startedTransactionId);
        }
        if (response.getHeader("X-Presto-Clear-Transaction-Id") != null) {
            this.clearTransactionId.set(true);
        }
        this.currentResults.set((QueryResults)response.getValue());
    }

    private RuntimeException requestFailedException(String task, Request request, FullJsonResponseHandler.JsonResponse<QueryResults> response) {
        this.gone.set(true);
        if (!response.hasValue()) {
            return new RuntimeException(String.format("Error %s at %s returned an invalid response: %s [Error: %s]", task, request.getUri(), response, response.getResponseBody()), response.getException());
        }
        return new RuntimeException(String.format("Error %s at %s returned %s: %s", task, request.getUri(), response.getStatusCode(), response.getStatusMessage()));
    }

    public boolean cancelLeafStage(Duration timeout) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"client is closed");
        URI uri = this.current().getPartialCancelUri();
        if (uri == null) {
            return false;
        }
        Request request = this.prepareRequest(Request.Builder.prepareDelete(), uri).build();
        HttpClient.HttpResponseFuture response = this.httpClient.executeAsync(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        try {
            StatusResponseHandler.StatusResponse status = (StatusResponseHandler.StatusResponse)response.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            return HttpStatus.familyForStatusCode((int)status.getStatusCode()) == HttpStatus.Family.SUCCESSFUL;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public void close() {
        URI uri;
        if (!this.closed.getAndSet(true) && (uri = this.currentResults.get().getNextUri()) != null) {
            Request request = this.prepareRequest(Request.Builder.prepareDelete(), uri).build();
            this.httpClient.executeAsync(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        }
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

