/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.client.NodeVersion;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ServerInfo {
    private final NodeVersion nodeVersion;
    private final String environment;
    private final boolean coordinator;

    @JsonCreator
    public ServerInfo(@JsonProperty(value="nodeVersion") NodeVersion nodeVersion, @JsonProperty(value="environment") String environment, @JsonProperty(value="coordinator") boolean coordinator) {
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.coordinator = Objects.requireNonNull(Boolean.valueOf(coordinator), "coordinator is null");
    }

    @JsonProperty
    public NodeVersion getNodeVersion() {
        return this.nodeVersion;
    }

    @JsonProperty
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty
    public boolean isCoordinator() {
        return this.coordinator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInfo that = (ServerInfo)o;
        return Objects.equals(this.nodeVersion, that.nodeVersion) && Objects.equals(this.environment, that.environment);
    }

    public int hashCode() {
        return Objects.hash(this.nodeVersion, this.environment);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeVersion", (Object)this.nodeVersion).add("environment", (Object)this.environment).add("coordinator", this.coordinator).toString();
    }
}

