/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.client.ClientSession;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.command.Option;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;

public class ClientOptions {
    @Option(name={"--server"}, title="server", description="Presto server location (default: localhost:8080)")
    public String server = "localhost:8080";
    @Option(name={"--user"}, title="user", description="Username")
    public String user = System.getProperty("user.name");
    @Option(name={"--source"}, title="source", description="Name of source making query")
    public String source = "presto-cli";
    @Option(name={"--catalog"}, title="catalog", description="Default catalog")
    public String catalog = "default";
    @Option(name={"--schema"}, title="schema", description="Default schema")
    public String schema = "default";
    @Option(name={"-f", "--file"}, title="file", description="Execute statements from file and exit")
    public String file;
    @Option(name={"--debug"}, title="debug", description="Enable debug information")
    public boolean debug;
    @Option(name={"--execute"}, title="execute", description="Execute specified statements and exit")
    public String execute;
    @Option(name={"--output-format"}, title="output-format", description="Output format for batch mode (default: CSV)")
    public OutputFormat outputFormat = OutputFormat.CSV;
    @Option(name={"--session"}, title="session", description="Session property (property can be used multiple times; format is key=value)")
    public final List<ClientSessionProperty> sessionProperties = new ArrayList<ClientSessionProperty>();

    public ClientSession toClientSession() {
        return new ClientSession(ClientOptions.parseServer(this.server), this.user, this.source, this.catalog, this.schema, TimeZone.getDefault().getID(), Locale.getDefault(), ClientOptions.toProperties(this.sessionProperties), this.debug);
    }

    public static URI parseServer(String server) {
        if ((server = server.toLowerCase(Locale.ENGLISH)).startsWith("http://") || server.startsWith("https://")) {
            return URI.create(server);
        }
        HostAndPort host = HostAndPort.fromString((String)server);
        try {
            return new URI("http", null, host.getHostText(), host.getPortOrDefault(80), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Map<String, String> toProperties(List<ClientSessionProperty> sessionProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ClientSessionProperty sessionProperty : sessionProperties) {
            String name = sessionProperty.getName();
            if (sessionProperty.getCatalog().isPresent()) {
                name = sessionProperty.getCatalog().get() + "." + name;
            }
            builder.put((Object)name, (Object)sessionProperty.getValue());
        }
        return builder.build();
    }

    public static final class ClientSessionProperty {
        private static final Splitter NAME_VALUE_SPLITTER = Splitter.on((char)'=').limit(2);
        private static final Splitter NAME_SPLITTER = Splitter.on((char)'.');
        private final Optional<String> catalog;
        private final String name;
        private final String value;

        public ClientSessionProperty(String property) {
            List nameValue = NAME_VALUE_SPLITTER.splitToList((CharSequence)property);
            Preconditions.checkArgument((nameValue.size() == 2 ? 1 : 0) != 0, (String)"Session property: %s", (Object[])new Object[]{property});
            List nameParts = NAME_SPLITTER.splitToList((CharSequence)nameValue.get(0));
            Preconditions.checkArgument((nameParts.size() == 1 || nameParts.size() == 2 ? 1 : 0) != 0, (String)"Invalid session property: %s", (Object[])new Object[]{property});
            if (nameParts.size() == 1) {
                this.catalog = Optional.empty();
                this.name = (String)nameParts.get(0);
            } else {
                this.catalog = Optional.of(nameParts.get(0));
                this.name = (String)nameParts.get(1);
            }
            this.value = (String)nameValue.get(1);
            ClientSessionProperty.verifyProperty(this.catalog, this.name, this.value);
        }

        public ClientSessionProperty(Optional<String> catalog, String name, String value) {
            this.catalog = (Optional)Preconditions.checkNotNull(catalog, (Object)"catalog is null");
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value is null");
            ClientSessionProperty.verifyProperty(catalog, name, value);
        }

        private static void verifyProperty(Optional<String> catalog, String name, String value) {
            Preconditions.checkArgument((!catalog.isPresent() || !catalog.get().isEmpty() ? 1 : 0) != 0, (String)"Invalid session property: %s.%s:%s", (Object[])new Object[]{catalog, name, value});
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Session property name is empty");
            CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
            Preconditions.checkArgument((catalog.orElse("").indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property catalog must not contain '=': %s", (Object[])new Object[]{name});
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(catalog.orElse("")), (String)"Session property catalog is not US_ASCII: %s", (Object[])new Object[]{name});
            Preconditions.checkArgument((name.indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property name must not contain '=': %s", (Object[])new Object[]{name});
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(name), (String)"Session property name is not US_ASCII: %s", (Object[])new Object[]{name});
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(value), (String)"Session property value is not US_ASCII: %s", (Object[])new Object[]{value});
        }

        public Optional<String> getCatalog() {
            return this.catalog;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return (this.catalog.isPresent() ? this.catalog.get() + '.' : "") + this.name + '=' + this.value;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.catalog, this.name, this.value});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ClientSessionProperty other = (ClientSessionProperty)obj;
            return Objects.equal(this.catalog, other.catalog) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.value, (Object)other.value);
        }
    }

    public static enum OutputFormat {
        ALIGNED,
        VERTICAL,
        CSV,
        TSV,
        CSV_HEADER,
        TSV_HEADER,
        NULL;

    }
}

