/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.ClientOptions;
import com.facebook.presto.cli.Query;
import com.facebook.presto.cli.QueryRunner;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.sql.parser.StatementSplitter;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import io.airlift.command.Command;
import io.airlift.command.HelpOption;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import javax.inject.Inject;
import jline.console.history.FileHistory;
import jline.console.history.MemoryHistory;
import jline.internal.Configuration;
import org.fusesource.jansi.AnsiConsole;

@Command(name="presto", description="Presto interactive console")
public class Console
implements Runnable {
    private static final String PROMPT_NAME = "presto";
    @Inject
    public HelpOption helpOption;
    @Inject
    public ClientOptions clientOptions = new ClientOptions();

    @Override
    public void run() {
        boolean isFromFile;
        ClientSession session = this.clientOptions.toClientSession();
        boolean hasQuery = !Strings.isNullOrEmpty((String)this.clientOptions.execute);
        boolean bl = isFromFile = !Strings.isNullOrEmpty((String)this.clientOptions.file);
        if (!hasQuery || !isFromFile) {
            AnsiConsole.systemInstall();
        }
        Console.initializeLogging(session.isDebug());
        String query = this.clientOptions.execute;
        if (isFromFile) {
            if (hasQuery) {
                throw new RuntimeException("both --execute and --file specified");
            }
            try {
                query = Files.toString((File)new File(this.clientOptions.file), (Charset)Charsets.UTF_8);
                hasQuery = true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading from file %s: %s", this.clientOptions.file, e.getMessage()));
            }
        }
        try (QueryRunner queryRunner = QueryRunner.create(session);){
            if (hasQuery) {
                Console.executeCommand(queryRunner, query, this.clientOptions.outputFormat);
            } else {
                this.runConsole(queryRunner, session);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void runConsole(QueryRunner queryRunner, ClientSession session) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 36[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void executeCommand(QueryRunner queryRunner, String query, ClientOptions.OutputFormat outputFormat) {
        StatementSplitter splitter = new StatementSplitter(query + ";");
        for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
            Console.process(queryRunner, split.statement(), outputFormat, false);
        }
    }

    private static void process(QueryRunner queryRunner, String sql, ClientOptions.OutputFormat outputFormat, boolean interactive) {
        block14: {
            try (Query query = queryRunner.startQuery(sql);){
                query.renderOutput(System.out, outputFormat, interactive);
            }
            catch (RuntimeException e) {
                System.out.println("Error running command: " + e.getMessage());
                if (!queryRunner.getSession().isDebug()) break block14;
                e.printStackTrace();
            }
        }
    }

    private static MemoryHistory getHistory() {
        FileHistory history;
        File historyFile = new File(Configuration.getUserHome(), ".presto_history");
        try {
            history = new FileHistory(historyFile);
        }
        catch (IOException e) {
            System.err.printf("WARNING: Failed to load history file (%s): %s. History will not be available during this session.%n", historyFile, e.getMessage());
            history = new MemoryHistory();
        }
        history.setAutoTrim(true);
        return history;
    }

    private static void initializeLogging(boolean debug) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            if (debug) {
                Logging logging = Logging.initialize();
                logging.configure(new LoggingConfiguration());
                logging.setLevel("com.facebook.presto", Logging.Level.DEBUG);
            } else {
                System.setOut(Console.nullPrintStream());
                System.setErr(Console.nullPrintStream());
                Logging logging = Logging.initialize();
                logging.configure(new LoggingConfiguration());
                logging.disableConsole();
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }

    private static PrintStream nullPrintStream() {
        return new PrintStream(ByteStreams.nullOutputStream());
    }
}

