/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.Query;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.google.common.base.Preconditions;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.netty.StandaloneNettyAsyncHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;

public class QueryRunner
implements Closeable {
    private final JsonCodec<QueryResults> queryResultsCodec;
    private final ClientSession session;
    private final AsyncHttpClient httpClient;

    public QueryRunner(ClientSession session, JsonCodec<QueryResults> queryResultsCodec) {
        this.session = (ClientSession)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.queryResultsCodec = (JsonCodec)Preconditions.checkNotNull(queryResultsCodec, (Object)"queryResultsCodec is null");
        this.httpClient = new StandaloneNettyAsyncHttpClient("cli", new HttpClientConfig().setConnectTimeout(new Duration(10.0, TimeUnit.SECONDS)));
    }

    public ClientSession getSession() {
        return this.session;
    }

    public Query startQuery(String query) {
        return new Query(this.startInternalQuery(query));
    }

    public StatementClient startInternalQuery(String query) {
        return new StatementClient(this.httpClient, this.queryResultsCodec, this.session, query);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public static QueryRunner create(ClientSession session) {
        return new QueryRunner(session, (JsonCodec<QueryResults>)JsonCodec.jsonCodec(QueryResults.class));
    }
}

