/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.google.common.base.Preconditions;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public class LdapRequestFilter
implements HttpRequestFilter {
    private final String user;
    private final String password;

    public LdapRequestFilter(String user, String password) {
        this.user = Objects.requireNonNull(user, "user is null");
        Preconditions.checkArgument((!user.contains(":") ? 1 : 0) != 0, (Object)"Illegal character ':' found in username");
        this.password = Objects.requireNonNull(password, "password is null");
    }

    public Request filterRequest(Request request) {
        String value = "Basic " + Base64.getEncoder().encodeToString((this.user + ":" + this.password).getBytes(StandardCharsets.ISO_8859_1));
        return Request.Builder.fromRequest((Request)request).addHeader("Authorization", value).build();
    }
}

