/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.OutputPrinter;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fusesource.jansi.AnsiString;

public class AlignedTablePrinter
implements OutputPrinter {
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n');
    private static final Splitter HEX_SPLITTER = Splitter.fixedLength((int)2);
    private static final Joiner HEX_BYTE_JOINER = Joiner.on((char)' ');
    private static final Joiner HEX_LINE_JOINER = Joiner.on((char)'\n');
    private final List<String> fieldNames;
    private final Writer writer;
    private boolean headerOutput;
    private long rowCount;

    public AlignedTablePrinter(List<String> fieldNames, Writer writer) {
        this.fieldNames = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(fieldNames, (Object)"fieldNames is null")));
        this.writer = (Writer)Preconditions.checkNotNull((Object)writer, (Object)"writer is null");
    }

    @Override
    public void finish() throws IOException {
        this.printRows((List<List<?>>)ImmutableList.of(), true);
        this.writer.append(String.format("(%s row%s)%n", this.rowCount, this.rowCount != 1L ? "s" : ""));
        this.writer.flush();
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        this.rowCount += (long)rows.size();
        int columns = this.fieldNames.size();
        int[] maxWidth = new int[columns];
        for (int i = 0; i < columns; ++i) {
            maxWidth[i] = Math.max(1, this.fieldNames.get(i).length());
        }
        for (List<?> row : rows) {
            for (int i = 0; i < row.size(); ++i) {
                String s = AlignedTablePrinter.formatValue(row.get(i));
                maxWidth[i] = Math.max(maxWidth[i], AlignedTablePrinter.maxLineLength(s));
            }
        }
        if (!this.headerOutput) {
            int i;
            this.headerOutput = true;
            for (i = 0; i < columns; ++i) {
                if (i > 0) {
                    this.writer.append('|');
                }
                String name = this.fieldNames.get(i);
                this.writer.append(AlignedTablePrinter.center(name, maxWidth[i], 1));
            }
            this.writer.append('\n');
            for (i = 0; i < columns; ++i) {
                if (i > 0) {
                    this.writer.append('+');
                }
                this.writer.append(Strings.repeat((String)"-", (int)(maxWidth[i] + 2)));
            }
            this.writer.append('\n');
        }
        for (List<?> row : rows) {
            Object lines;
            ArrayList<ImmutableList> columnLines = new ArrayList<ImmutableList>(columns);
            int maxLines = 1;
            for (int i = 0; i < columns; ++i) {
                String s = AlignedTablePrinter.formatValue(row.get(i));
                lines = ImmutableList.copyOf((Iterable)LINE_SPLITTER.split((CharSequence)s));
                columnLines.add((ImmutableList)lines);
                maxLines = Math.max(maxLines, lines.size());
            }
            for (int line = 0; line < maxLines; ++line) {
                for (int column = 0; column < columns; ++column) {
                    if (column > 0) {
                        this.writer.append('|');
                    }
                    String s = line < (lines = (List)columnLines.get(column)).size() ? (String)lines.get(line) : "";
                    boolean numeric = row.get(column) instanceof Number;
                    String out = AlignedTablePrinter.align(s, maxWidth[column], 1, numeric);
                    if (!(complete && this.rowCount <= 1L || line + 1 >= lines.size())) {
                        out = out.substring(0, out.length() - 1) + "+";
                    }
                    this.writer.append(out);
                }
                this.writer.append('\n');
            }
        }
        this.writer.flush();
    }

    static String formatValue(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof byte[]) {
            return AlignedTablePrinter.formatHexDump((byte[])o, 16);
        }
        return o.toString();
    }

    private static String formatHexDump(byte[] bytes, int bytesPerLine) {
        String hexDump = BaseEncoding.base16().lowerCase().encode(bytes);
        Iterable hexPairs = HEX_SPLITTER.split((CharSequence)hexDump);
        Iterable hexLines = Iterables.partition((Iterable)hexPairs, (int)bytesPerLine);
        Iterable lines = Iterables.transform((Iterable)hexLines, arg_0 -> ((Joiner)HEX_BYTE_JOINER).join(arg_0));
        return HEX_LINE_JOINER.join(lines);
    }

    private static String center(String s, int maxWidth, int padding) {
        AnsiString ansiString = new AnsiString((CharSequence)s);
        Preconditions.checkState((ansiString.length() <= maxWidth ? 1 : 0) != 0, (Object)"string length is greater than max width");
        int left = (maxWidth - ansiString.length()) / 2;
        int right = maxWidth - (left + ansiString.length());
        return Strings.repeat((String)" ", (int)(left + padding)) + s + Strings.repeat((String)" ", (int)(right + padding));
    }

    private static String align(String s, int maxWidth, int padding, boolean right) {
        AnsiString ansiString = new AnsiString((CharSequence)s);
        Preconditions.checkState((ansiString.length() <= maxWidth ? 1 : 0) != 0, (Object)"string length is greater than max width");
        String large = Strings.repeat((String)" ", (int)(maxWidth - ansiString.length() + padding));
        String small = Strings.repeat((String)" ", (int)padding);
        return right ? large + s + small : small + s + large;
    }

    static int maxLineLength(String s) {
        int n = 0;
        for (String line : LINE_SPLITTER.split((CharSequence)s)) {
            n = Math.max(n, new AnsiString((CharSequence)line).length());
        }
        return n;
    }
}

