/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.AbstractTableMetadata;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraErrorCode;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.ExtraColumnMetadata;
import com.facebook.presto.cassandra.SizeEstimate;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NativeCassandraSession
implements CassandraSession {
    private static final Logger log = Logger.get(NativeCassandraSession.class);
    private final LoadingCache<String, KeyspaceMetadata> keyspaceCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, KeyspaceMetadata>(){

        public KeyspaceMetadata load(String key) throws Exception {
            return NativeCassandraSession.this.getKeyspaceByCaseInsensitiveName0(key);
        }
    });
    private static final String PRESTO_COMMENT_METADATA = "Presto Metadata:";
    private static final String SYSTEM = "system";
    private static final String SIZE_ESTIMATES = "size_estimates";
    private static final VersionNumber PARTITION_FETCH_WITH_IN_PREDICATE_VERSION = VersionNumber.parse((String)"2.2");
    private final String connectorId;
    private final JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec;
    private final Cluster cluster;
    private final Supplier<Session> session;
    private final Duration noHostAvailableRetryTimeout;

    public NativeCassandraSession(String connectorId, JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec, Cluster cluster, Duration noHostAvailableRetryTimeout) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.extraColumnMetadataCodec = Objects.requireNonNull(extraColumnMetadataCodec, "extraColumnMetadataCodec is null");
        this.cluster = Objects.requireNonNull(cluster, "cluster is null");
        this.noHostAvailableRetryTimeout = Objects.requireNonNull(noHostAvailableRetryTimeout, "noHostAvailableRetryTimeout is null");
        this.session = Suppliers.memoize(() -> ((Cluster)cluster).connect());
    }

    @Override
    public VersionNumber getCassandraVersion() {
        ResultSet result = this.executeWithSession(session -> session.execute("select release_version from system.local"));
        Row versionRow = result.one();
        if (versionRow == null) {
            throw new PrestoException((ErrorCodeSupplier)CassandraErrorCode.CASSANDRA_VERSION_ERROR, "The cluster version is not available. Please make sure that the Cassandra cluster is up and running, and that the contact points are specified correctly.");
        }
        return VersionNumber.parse((String)versionRow.getString("release_version"));
    }

    @Override
    public String getPartitioner() {
        return this.executeWithSession(session -> session.getCluster().getMetadata().getPartitioner());
    }

    @Override
    public Set<TokenRange> getTokenRanges() {
        return this.executeWithSession(session -> session.getCluster().getMetadata().getTokenRanges());
    }

    @Override
    public Set<Host> getReplicas(String caseSensitiveSchemaName, TokenRange tokenRange) {
        Objects.requireNonNull(caseSensitiveSchemaName, "keyspace is null");
        Objects.requireNonNull(tokenRange, "tokenRange is null");
        return this.executeWithSession(session -> session.getCluster().getMetadata().getReplicas(CassandraCqlUtils.validSchemaName(caseSensitiveSchemaName), tokenRange));
    }

    @Override
    public Set<Host> getReplicas(String caseSensitiveSchemaName, ByteBuffer partitionKey) {
        Objects.requireNonNull(caseSensitiveSchemaName, "keyspace is null");
        Objects.requireNonNull(partitionKey, "partitionKey is null");
        return this.executeWithSession(session -> session.getCluster().getMetadata().getReplicas(CassandraCqlUtils.validSchemaName(caseSensitiveSchemaName), partitionKey));
    }

    @Override
    public String getCaseSensitiveSchemaName(String caseInsensitiveSchemaName) {
        return this.getKeyspaceByCaseInsensitiveName(caseInsensitiveSchemaName).getName();
    }

    @Override
    public List<String> getCaseSensitiveSchemaNames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        List keyspaces = this.executeWithSession(session -> session.getCluster().getMetadata().getKeyspaces());
        for (KeyspaceMetadata meta : keyspaces) {
            builder.add((Object)meta.getName());
        }
        return builder.build();
    }

    @Override
    public List<String> getCaseSensitiveTableNames(String caseInsensitiveSchemaName) throws SchemaNotFoundException {
        KeyspaceMetadata keyspace = this.getKeyspaceByCaseInsensitiveName(caseInsensitiveSchemaName);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TableMetadata table : keyspace.getTables()) {
            builder.add((Object)table.getName());
        }
        for (MaterializedViewMetadata materializedView : keyspace.getMaterializedViews()) {
            builder.add((Object)materializedView.getName());
        }
        return builder.build();
    }

    @Override
    public CassandraTable getTable(SchemaTableName schemaTableName) throws TableNotFoundException {
        CassandraColumnHandle columnHandle;
        boolean hidden;
        KeyspaceMetadata keyspace = this.getKeyspaceByCaseInsensitiveName(schemaTableName.getSchemaName());
        AbstractTableMetadata tableMeta = NativeCassandraSession.getTableMetadata(keyspace, schemaTableName.getTableName());
        List columnNames = new ArrayList<String>();
        List columns = tableMeta.getColumns();
        NativeCassandraSession.checkColumnNames(columns);
        for (ColumnMetadata columnMetadata : columns) {
            columnNames.add(columnMetadata.getName());
        }
        String comment = tableMeta.getOptions().getComment();
        ImmutableSet hiddenColumns = ImmutableSet.of();
        if (comment != null && comment.startsWith(PRESTO_COMMENT_METADATA)) {
            String columnOrderingString = comment.substring(PRESTO_COMMENT_METADATA.length());
            List extras = (List)this.extraColumnMetadataCodec.fromJson(columnOrderingString);
            Iterator explicitColumnOrder = new ArrayList(ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)extras, ExtraColumnMetadata::getName)));
            hiddenColumns = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)extras, ExtraColumnMetadata::isHidden), ExtraColumnMetadata::getName));
            Iterables.addAll(explicitColumnOrder, (Iterable)Iterables.filter(columnNames, (Predicate)Predicates.not((Predicate)Predicates.in(explicitColumnOrder))));
            columnNames = Ordering.explicit(explicitColumnOrder).sortedCopy(columnNames);
        }
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        HashSet<String> primaryKeySet = new HashSet<String>();
        for (ColumnMetadata columnMeta : tableMeta.getPartitionKey()) {
            primaryKeySet.add(columnMeta.getName());
            hidden = hiddenColumns.contains(columnMeta.getName());
            columnHandle = this.buildColumnHandle(tableMeta, columnMeta, true, false, columnNames.indexOf(columnMeta.getName()), hidden);
            columnHandles.add((Object)columnHandle);
        }
        for (ColumnMetadata columnMeta : tableMeta.getClusteringColumns()) {
            primaryKeySet.add(columnMeta.getName());
            hidden = hiddenColumns.contains(columnMeta.getName());
            columnHandle = this.buildColumnHandle(tableMeta, columnMeta, false, true, columnNames.indexOf(columnMeta.getName()), hidden);
            columnHandles.add((Object)columnHandle);
        }
        for (ColumnMetadata columnMeta : columns) {
            if (primaryKeySet.contains(columnMeta.getName())) continue;
            hidden = hiddenColumns.contains(columnMeta.getName());
            columnHandle = this.buildColumnHandle(tableMeta, columnMeta, false, false, columnNames.indexOf(columnMeta.getName()), hidden);
            columnHandles.add((Object)columnHandle);
        }
        List<CassandraColumnHandle> sortedColumnHandles = columnHandles.build().stream().sorted(Comparator.comparing(CassandraColumnHandle::getOrdinalPosition)).collect(Collectors.toList());
        CassandraTableHandle tableHandle = new CassandraTableHandle(this.connectorId, tableMeta.getKeyspace().getName(), tableMeta.getName());
        return new CassandraTable(tableHandle, sortedColumnHandles);
    }

    private KeyspaceMetadata getKeyspaceByCaseInsensitiveName(String caseInsensitiveSchemaName) throws SchemaNotFoundException {
        try {
            return (KeyspaceMetadata)this.keyspaceCache.get((Object)caseInsensitiveSchemaName);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SchemaNotFoundException) {
                throw (SchemaNotFoundException)cause;
            }
            if (cause instanceof PrestoException) {
                throw (PrestoException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private KeyspaceMetadata getKeyspaceByCaseInsensitiveName0(String caseInsensitiveSchemaName) throws SchemaNotFoundException {
        List keyspaces = this.executeWithSession(session -> session.getCluster().getMetadata().getKeyspaces());
        KeyspaceMetadata result = null;
        ImmutableList sortedKeyspaces = Ordering.from(Comparator.comparing(KeyspaceMetadata::getName)).immutableSortedCopy((Iterable)keyspaces);
        for (KeyspaceMetadata keyspace : sortedKeyspaces) {
            if (!keyspace.getName().equalsIgnoreCase(caseInsensitiveSchemaName)) continue;
            if (result != null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("More than one keyspace has been found for the case insensitive schema name: %s -> (%s, %s)", caseInsensitiveSchemaName, result.getName(), keyspace.getName()));
            }
            result = keyspace;
        }
        if (result == null) {
            throw new SchemaNotFoundException(caseInsensitiveSchemaName);
        }
        return result;
    }

    private static AbstractTableMetadata getTableMetadata(KeyspaceMetadata keyspace, String caseInsensitiveTableName) {
        List tables = (List)Stream.concat(keyspace.getTables().stream(), keyspace.getMaterializedViews().stream()).filter(table -> table.getName().equalsIgnoreCase(caseInsensitiveTableName)).collect(ImmutableList.toImmutableList());
        if (tables.size() == 0) {
            throw new TableNotFoundException(new SchemaTableName(keyspace.getName(), caseInsensitiveTableName));
        }
        if (tables.size() == 1) {
            return (AbstractTableMetadata)tables.get(0);
        }
        String tableNames = tables.stream().map(AbstractTableMetadata::getName).sorted().collect(Collectors.joining(", "));
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("More than one table has been found for the case insensitive table name: %s -> (%s)", caseInsensitiveTableName, tableNames));
    }

    @Override
    public boolean isMaterializedView(SchemaTableName schemaTableName) {
        KeyspaceMetadata keyspace = this.getKeyspaceByCaseInsensitiveName(schemaTableName.getSchemaName());
        return keyspace.getMaterializedView(schemaTableName.getTableName()) != null;
    }

    private static void checkColumnNames(List<ColumnMetadata> columns) {
        HashMap<String, ColumnMetadata> lowercaseNameToColumnMap = new HashMap<String, ColumnMetadata>();
        for (ColumnMetadata column : columns) {
            String lowercaseName = column.getName().toLowerCase(Locale.ENGLISH);
            if (lowercaseNameToColumnMap.containsKey(lowercaseName)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("More than one column has been found for the case insensitive column name: %s -> (%s, %s)", lowercaseName, ((ColumnMetadata)lowercaseNameToColumnMap.get(lowercaseName)).getName(), column.getName()));
            }
            lowercaseNameToColumnMap.put(lowercaseName, column);
        }
    }

    private CassandraColumnHandle buildColumnHandle(AbstractTableMetadata tableMetadata, ColumnMetadata columnMeta, boolean partitionKey, boolean clusteringKey, int ordinalPosition, boolean hidden) {
        CassandraType cassandraType = CassandraType.getCassandraType(columnMeta.getType().getName());
        ImmutableList typeArguments = null;
        if (cassandraType != null && cassandraType.getTypeArgumentSize() > 0) {
            List typeArgs = columnMeta.getType().getTypeArguments();
            switch (cassandraType.getTypeArgumentSize()) {
                case 1: {
                    typeArguments = ImmutableList.of((Object)CassandraType.getCassandraType(((DataType)typeArgs.get(0)).getName()));
                    break;
                }
                case 2: {
                    typeArguments = ImmutableList.of((Object)CassandraType.getCassandraType(((DataType)typeArgs.get(0)).getName()), (Object)CassandraType.getCassandraType(((DataType)typeArgs.get(1)).getName()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type arguments: " + typeArgs);
                }
            }
        }
        boolean indexed = false;
        SchemaTableName schemaTableName = new SchemaTableName(tableMetadata.getKeyspace().getName(), tableMetadata.getName());
        if (!this.isMaterializedView(schemaTableName)) {
            TableMetadata table = (TableMetadata)tableMetadata;
            for (IndexMetadata idx : table.getIndexes()) {
                if (!idx.getTarget().equals(columnMeta.getName())) continue;
                indexed = true;
                break;
            }
        }
        return new CassandraColumnHandle(this.connectorId, columnMeta.getName(), ordinalPosition, cassandraType, (List<CassandraType>)typeArguments, partitionKey, clusteringKey, indexed, hidden);
    }

    @Override
    public List<CassandraPartition> getPartitions(CassandraTable table, List<Set<Object>> filterPrefixes) {
        Iterable<Row> rows;
        List<CassandraColumnHandle> partitionKeyColumns = table.getPartitionKeyColumns();
        if (filterPrefixes.size() != partitionKeyColumns.size()) {
            return ImmutableList.of((Object)CassandraPartition.UNPARTITIONED);
        }
        if (this.getCassandraVersion().compareTo(PARTITION_FETCH_WITH_IN_PREDICATE_VERSION) > 0) {
            log.debug("Using IN predicate to fetch partitions.");
            rows = this.queryPartitionKeysWithInClauses(table, filterPrefixes);
        } else {
            log.debug("Using combination of partition values to fetch partitions.");
            rows = this.queryPartitionKeysLegacyWithMultipleQueries(table, filterPrefixes);
        }
        if (rows == null) {
            return ImmutableList.of((Object)CassandraPartition.UNPARTITIONED);
        }
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        HashMap<CassandraColumnHandle, NullableValue> map = new HashMap<CassandraColumnHandle, NullableValue>();
        HashSet<String> uniquePartitionIds = new HashSet<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean isComposite = partitionKeyColumns.size() > 1;
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (Row row : rows) {
            buffer.clear();
            map.clear();
            stringBuilder.setLength(0);
            for (int i = 0; i < partitionKeyColumns.size(); ++i) {
                ByteBuffer component = row.getBytesUnsafe(i);
                if (isComposite) {
                    short len = (short)component.limit();
                    buffer.putShort(len);
                    buffer.put(component);
                    buffer.put((byte)0);
                } else {
                    buffer.put(component);
                }
                CassandraColumnHandle columnHandle = partitionKeyColumns.get(i);
                NullableValue keyPart = CassandraType.getColumnValueForPartitionKey(row, i, columnHandle.getCassandraType(), columnHandle.getTypeArguments());
                map.put(columnHandle, keyPart);
                if (i > 0) {
                    stringBuilder.append(" AND ");
                }
                stringBuilder.append(CassandraCqlUtils.validColumnName(columnHandle.getName()));
                stringBuilder.append(" = ");
                stringBuilder.append(CassandraType.getColumnValueForCql(row, i, columnHandle.getCassandraType()));
            }
            buffer.flip();
            byte[] key = new byte[buffer.limit()];
            buffer.get(key);
            TupleDomain tupleDomain = TupleDomain.fromFixedValues(map);
            String partitionId = stringBuilder.toString();
            if (!uniquePartitionIds.add(partitionId)) continue;
            partitions.add((Object)new CassandraPartition(key, partitionId, (TupleDomain<ColumnHandle>)tupleDomain, false));
        }
        return partitions.build();
    }

    @Override
    public ResultSet execute(String cql, Object ... values) {
        return this.executeWithSession(session -> session.execute(cql, values));
    }

    @Override
    public PreparedStatement prepare(RegularStatement statement) {
        return this.executeWithSession(session -> session.prepare(statement));
    }

    @Override
    public ResultSet execute(Statement statement) {
        return this.executeWithSession(session -> session.execute(statement));
    }

    private Iterable<Row> queryPartitionKeysWithInClauses(CassandraTable table, List<Set<Object>> filterPrefixes) {
        CassandraTableHandle tableHandle = table.getTableHandle();
        List<CassandraColumnHandle> partitionKeyColumns = table.getPartitionKeyColumns();
        Select partitionKeys = CassandraCqlUtils.selectDistinctFrom(tableHandle, partitionKeyColumns);
        NativeCassandraSession.addWhereInClauses(partitionKeys.where(), partitionKeyColumns, filterPrefixes);
        return this.execute((Statement)partitionKeys).all();
    }

    private Iterable<Row> queryPartitionKeysLegacyWithMultipleQueries(CassandraTable table, List<Set<Object>> filterPrefixes) {
        CassandraTableHandle tableHandle = table.getTableHandle();
        List<CassandraColumnHandle> partitionKeyColumns = table.getPartitionKeyColumns();
        Set filterCombinations = Sets.cartesianProduct(filterPrefixes);
        ImmutableList.Builder rowList = ImmutableList.builder();
        for (List combination : filterCombinations) {
            Select partitionKeys = CassandraCqlUtils.selectDistinctFrom(tableHandle, partitionKeyColumns);
            NativeCassandraSession.addWhereClause(partitionKeys.where(), partitionKeyColumns, combination);
            List resultRows = this.execute((Statement)partitionKeys).all();
            if (resultRows == null || resultRows.isEmpty()) continue;
            rowList.addAll((Iterable)resultRows);
        }
        return rowList.build();
    }

    private static void addWhereInClauses(Select.Where where, List<CassandraColumnHandle> partitionKeyColumns, List<Set<Object>> filterPrefixes) {
        for (int i = 0; i < filterPrefixes.size(); ++i) {
            CassandraColumnHandle column = partitionKeyColumns.get(i);
            List values = filterPrefixes.get(i).stream().map(value -> column.getCassandraType().getJavaValue(value)).collect(Collectors.toList());
            Clause clause = QueryBuilder.in((String)CassandraCqlUtils.validColumnName(column.getName()), values);
            where.and(clause);
        }
    }

    private static void addWhereClause(Select.Where where, List<CassandraColumnHandle> partitionKeyColumns, List<Object> filterPrefix) {
        for (int i = 0; i < filterPrefix.size(); ++i) {
            CassandraColumnHandle column = partitionKeyColumns.get(i);
            Object value = column.getCassandraType().getJavaValue(filterPrefix.get(i));
            Clause clause = QueryBuilder.eq((String)CassandraCqlUtils.validColumnName(column.getName()), (Object)value);
            where.and(clause);
        }
    }

    @Override
    public List<SizeEstimate> getSizeEstimates(String keyspaceName, String tableName) {
        this.checkSizeEstimatesTableExist();
        Select.Where statement = QueryBuilder.select((String[])new String[]{"range_start", "range_end", "mean_partition_size", "partitions_count"}).from(SYSTEM, SIZE_ESTIMATES).where(QueryBuilder.eq((String)"keyspace_name", (Object)keyspaceName)).and(QueryBuilder.eq((String)"table_name", (Object)tableName));
        ResultSet result = this.executeWithSession(arg_0 -> NativeCassandraSession.lambda$getSizeEstimates$12((Statement)statement, arg_0));
        ImmutableList.Builder estimates = ImmutableList.builder();
        for (Row row : result.all()) {
            SizeEstimate estimate = new SizeEstimate(row.getString("range_start"), row.getString("range_end"), row.getLong("mean_partition_size"), row.getLong("partitions_count"));
            estimates.add((Object)estimate);
        }
        return estimates.build();
    }

    private void checkSizeEstimatesTableExist() {
        KeyspaceMetadata keyspaceMetadata = this.executeWithSession(session -> session.getCluster().getMetadata().getKeyspace(SYSTEM));
        Preconditions.checkState((keyspaceMetadata != null ? 1 : 0) != 0, (Object)"system keyspace metadata must not be null");
        TableMetadata table = keyspaceMetadata.getTable(SIZE_ESTIMATES);
        if (table == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cassandra versions prior to 2.1.5 are not supported");
        }
    }

    private <T> T executeWithSession(SessionCallable<T> sessionCallable) {
        ReconnectionPolicy reconnectionPolicy = this.cluster.getConfiguration().getPolicies().getReconnectionPolicy();
        ReconnectionPolicy.ReconnectionSchedule schedule = reconnectionPolicy.newSchedule();
        long deadline = System.currentTimeMillis() + this.noHostAvailableRetryTimeout.toMillis();
        while (true) {
            try {
                return sessionCallable.executeWithSession((Session)this.session.get());
            }
            catch (NoHostAvailableException e) {
                long timeLeft = deadline - System.currentTimeMillis();
                if (timeLeft <= 0L) {
                    throw e;
                }
                long delay = Math.min(schedule.nextDelayMs(), timeLeft);
                log.warn(e.getCustomMessage(10, true, true));
                log.warn("Reconnecting in %dms", new Object[]{delay});
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("interrupted", interrupted);
                }
            }
        }
    }

    private static /* synthetic */ ResultSet lambda$getSizeEstimates$12(Statement statement, Session session) {
        return session.execute(statement);
    }

    private static interface SessionCallable<T> {
        public T executeWithSession(Session var1);
    }
}

