/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.FullCassandraType;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.RecordCursor;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;

public class CassandraRecordCursor
implements RecordCursor {
    private final List<FullCassandraType> fullCassandraTypes;
    private final ResultSet rs;
    private Row currentRow;
    private long count;

    public CassandraRecordCursor(CassandraSession cassandraSession, List<FullCassandraType> fullCassandraTypes, String cql) {
        this.fullCassandraTypes = fullCassandraTypes;
        this.rs = cassandraSession.execute(cql, new Object[0]);
        this.currentRow = null;
    }

    public boolean advanceNextPosition() {
        if (!this.rs.isExhausted()) {
            this.currentRow = this.rs.one();
            ++this.count;
            return true;
        }
        return false;
    }

    public void close() {
    }

    public boolean getBoolean(int i) {
        return this.currentRow.getBool(i);
    }

    public long getCompletedBytes() {
        return this.count;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public double getDouble(int i) {
        switch (this.getCassandraType(i)) {
            case DOUBLE: {
                return this.currentRow.getDouble(i);
            }
            case FLOAT: {
                return this.currentRow.getFloat(i);
            }
            case DECIMAL: {
                return this.currentRow.getDecimal(i).doubleValue();
            }
        }
        throw new IllegalStateException("Cannot retrieve double for " + this.getCassandraType(i));
    }

    public long getLong(int i) {
        switch (this.getCassandraType(i)) {
            case INT: {
                return this.currentRow.getInt(i);
            }
            case SMALLINT: {
                return this.currentRow.getShort(i);
            }
            case TINYINT: {
                return this.currentRow.getByte(i);
            }
            case BIGINT: 
            case COUNTER: {
                return this.currentRow.getLong(i);
            }
            case TIMESTAMP: {
                return this.currentRow.getTimestamp(i).getTime();
            }
            case DATE: {
                return this.currentRow.getDate(i).getDaysSinceEpoch();
            }
            case FLOAT: {
                return Float.floatToRawIntBits(this.currentRow.getFloat(i));
            }
        }
        throw new IllegalStateException("Cannot retrieve long for " + this.getCassandraType(i));
    }

    private CassandraType getCassandraType(int i) {
        return this.fullCassandraTypes.get(i).getCassandraType();
    }

    public Slice getSlice(int i) {
        NullableValue value = CassandraType.getColumnValue(this.currentRow, i, this.fullCassandraTypes.get(i));
        if (value.getValue() instanceof Slice) {
            return (Slice)value.getValue();
        }
        return Slices.utf8Slice((String)value.getValue().toString());
    }

    public Object getObject(int field) {
        throw new UnsupportedOperationException();
    }

    public Type getType(int i) {
        return this.getCassandraType(i).getNativeType();
    }

    public boolean isNull(int i) {
        return this.currentRow.isNull(i);
    }
}

