/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.Host;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraSessionProperties;
import com.facebook.presto.cassandra.CassandraSplit;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.CassandraTableLayoutHandle;
import com.facebook.presto.cassandra.CassandraTokenSplitManager;
import com.facebook.presto.cassandra.util.HostAddressFactory;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class CassandraSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final CassandraSession cassandraSession;
    private final int partitionSizeForBatchSelect;
    private final CassandraTokenSplitManager tokenSplitMgr;

    @Inject
    public CassandraSplitManager(CassandraConnectorId connectorId, CassandraClientConfig cassandraClientConfig, CassandraSession cassandraSession, CassandraTokenSplitManager tokenSplitMgr) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
        this.partitionSizeForBatchSelect = cassandraClientConfig.getPartitionSizeForBatchSelect();
        this.tokenSplitMgr = tokenSplitMgr;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        CassandraPartition cassandraPartition;
        CassandraTableLayoutHandle layoutHandle = (CassandraTableLayoutHandle)layout;
        CassandraTableHandle cassandraTableHandle = layoutHandle.getTable();
        List<CassandraPartition> partitions = layoutHandle.getPartitions();
        if (partitions.isEmpty()) {
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        if (partitions.size() == 1 && ((cassandraPartition = partitions.get(0)).isUnpartitioned() || cassandraPartition.isIndexedColumnPredicatePushdown())) {
            CassandraTable table = this.cassandraSession.getTable(cassandraTableHandle.getSchemaTableName());
            List<ConnectorSplit> splits = this.getSplitsByTokenRange(table, cassandraPartition.getPartitionId(), CassandraSessionProperties.getSplitsPerNode(session));
            return new FixedSplitSource(splits);
        }
        return new FixedSplitSource(this.getSplitsForPartitions(cassandraTableHandle, partitions, layoutHandle.getClusteringPredicates()));
    }

    private List<ConnectorSplit> getSplitsByTokenRange(CassandraTable table, String partitionId, Optional<Long> sessionSplitsPerNode) {
        String schema = table.getTableHandle().getSchemaName();
        String tableName = table.getTableHandle().getTableName();
        String tokenExpression = table.getTokenExpression();
        ImmutableList.Builder builder = ImmutableList.builder();
        List<CassandraTokenSplitManager.TokenSplit> tokenSplits = this.tokenSplitMgr.getSplits(schema, tableName, sessionSplitsPerNode);
        for (CassandraTokenSplitManager.TokenSplit tokenSplit : tokenSplits) {
            String condition = CassandraSplitManager.buildTokenCondition(tokenExpression, tokenSplit.getStartToken(), tokenSplit.getEndToken());
            List<HostAddress> addresses = new HostAddressFactory().AddressNamesToHostAddressList(tokenSplit.getHosts());
            CassandraSplit split = new CassandraSplit(this.connectorId, schema, tableName, partitionId, condition, addresses);
            builder.add((Object)split);
        }
        return builder.build();
    }

    private static String buildTokenCondition(String tokenExpression, String startToken, String endToken) {
        return tokenExpression + " > " + startToken + " AND " + tokenExpression + " <= " + endToken;
    }

    private List<ConnectorSplit> getSplitsForPartitions(CassandraTableHandle cassTableHandle, List<CassandraPartition> partitions, String clusteringPredicates) {
        String schema = cassTableHandle.getSchemaName();
        HostAddressFactory hostAddressFactory = new HostAddressFactory();
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean singlePartitionKeyColumn = true;
        String partitionKeyColumnName = null;
        if (!partitions.isEmpty()) {
            boolean bl = singlePartitionKeyColumn = ((Map)partitions.get(0).getTupleDomain().getDomains().get()).size() == 1;
            if (singlePartitionKeyColumn) {
                String partitionId = partitions.get(0).getPartitionId();
                partitionKeyColumnName = partitionId.substring(0, partitionId.lastIndexOf(61) - 1);
            }
        }
        HashMap hostsToPartitionKeys = new HashMap();
        HashMap<ImmutableSet, List<HostAddress>> hostMap = new HashMap<ImmutableSet, List<HostAddress>>();
        for (CassandraPartition cassandraPartition : partitions) {
            Set<Host> hosts = this.cassandraSession.getReplicas(schema, cassandraPartition.getKeyAsByteBuffer());
            List<HostAddress> addresses = hostAddressFactory.toHostAddressList(hosts);
            if (singlePartitionKeyColumn) {
                ImmutableSet.Builder sb = ImmutableSet.builder();
                for (HostAddress address : addresses) {
                    sb.add((Object)address.getHostText());
                }
                ImmutableSet hostAddresses = sb.build();
                HashSet<String> values = (HashSet<String>)hostsToPartitionKeys.get(hostAddresses);
                if (values == null) {
                    values = new HashSet<String>();
                }
                String partitionId = cassandraPartition.getPartitionId();
                values.add(partitionId.substring(partitionId.lastIndexOf(61) + 2));
                hostsToPartitionKeys.put(hostAddresses, values);
                hostMap.put(hostAddresses, addresses);
                continue;
            }
            builder.add((Object)this.createSplitForClusteringPredicates(cassTableHandle, cassandraPartition.getPartitionId(), addresses, clusteringPredicates));
        }
        if (singlePartitionKeyColumn) {
            for (Map.Entry entry : hostsToPartitionKeys.entrySet()) {
                StringBuilder sb = new StringBuilder(this.partitionSizeForBatchSelect);
                int size = 0;
                for (String value : (Set)entry.getValue()) {
                    if (size > 0) {
                        sb.append(",");
                    }
                    sb.append(value);
                    if (++size <= this.partitionSizeForBatchSelect) continue;
                    String partitionId = String.format("%s in (%s)", partitionKeyColumnName, sb.toString());
                    builder.add((Object)this.createSplitForClusteringPredicates(cassTableHandle, partitionId, (List)hostMap.get(entry.getKey()), clusteringPredicates));
                    size = 0;
                    sb.setLength(0);
                    sb.trimToSize();
                }
                if (size <= 0) continue;
                String partitionId = String.format("%s in (%s)", partitionKeyColumnName, sb.toString());
                builder.add((Object)this.createSplitForClusteringPredicates(cassTableHandle, partitionId, (List)hostMap.get(entry.getKey()), clusteringPredicates));
            }
        }
        return builder.build();
    }

    private CassandraSplit createSplitForClusteringPredicates(CassandraTableHandle tableHandle, String partitionId, List<HostAddress> hosts, String clusteringPredicates) {
        String schema = tableHandle.getSchemaName();
        String table = tableHandle.getTableName();
        if (clusteringPredicates.isEmpty()) {
            return new CassandraSplit(this.connectorId, schema, table, partitionId, null, hosts);
        }
        return new CassandraSplit(this.connectorId, schema, table, partitionId, clusteringPredicates, hosts);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.connectorId).toString();
    }
}

