/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import alluxio.client.file.URIStatus;
import alluxio.hadoop.LocalCacheFileSystem;
import alluxio.wire.FileInfo;
import com.facebook.presto.cache.CachingFileSystem;
import com.facebook.presto.cache.alluxio.AlluxioURIStatus;
import com.facebook.presto.cache.alluxio.CacheValidatingInputStream;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class AlluxioCachingFileSystem
extends CachingFileSystem {
    private static final int BUFFER_SIZE = 65536;
    private final boolean cacheValidationEnabled;
    private LocalCacheFileSystem localCacheFileSystem;

    public AlluxioCachingFileSystem(ExtendedFileSystem dataTier, URI uri) {
        this(dataTier, uri, false);
    }

    public AlluxioCachingFileSystem(ExtendedFileSystem dataTier, URI uri, boolean cacheValidationEnabled) {
        super(dataTier, uri);
        this.cacheValidationEnabled = cacheValidationEnabled;
    }

    @Override
    public synchronized void initialize(URI uri, Configuration configuration) throws IOException {
        this.localCacheFileSystem = new LocalCacheFileSystem((FileSystem)this.dataTier, uriStatus -> {
            Preconditions.checkState((boolean)(uriStatus instanceof AlluxioURIStatus));
            HiveFileContext hiveFileContext = ((AlluxioURIStatus)uriStatus).getHiveFileContext();
            try {
                return this.dataTier.openFile(new Path(uriStatus.getPath()), hiveFileContext);
            }
            catch (Exception e) {
                throw new IOException("Failed to open file", e);
            }
        });
        this.localCacheFileSystem.initialize(uri, configuration);
    }

    @Override
    public FSDataInputStream openFile(Path path, HiveFileContext hiveFileContext) throws Exception {
        if (hiveFileContext.isCacheable() && hiveFileContext.getFileSize().isPresent()) {
            FileInfo info = new FileInfo().setFileIdentifier(Hashing.md5().hashString((CharSequence)path.toString(), StandardCharsets.UTF_8).toString()).setPath(path.toString()).setFolder(false).setLength(((Long)hiveFileContext.getFileSize().get()).longValue());
            AlluxioURIStatus alluxioURIStatus = new AlluxioURIStatus(info, hiveFileContext);
            FSDataInputStream cachingInputStream = this.localCacheFileSystem.open((URIStatus)alluxioURIStatus, 65536);
            if (this.cacheValidationEnabled) {
                return new CacheValidatingInputStream(cachingInputStream, this.dataTier.openFile(path, hiveFileContext));
            }
            return cachingInputStream;
        }
        return this.dataTier.openFile(path, hiveFileContext);
    }
}

