/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import alluxio.client.file.URIStatus;
import alluxio.hadoop.LocalCacheFileSystem;
import com.facebook.presto.cache.CachingFileSystem;
import com.facebook.presto.cache.alluxio.AlluxioURIStatus;
import com.facebook.presto.cache.alluxio.CacheValidatingInputStream;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class AlluxioCachingFileSystem
extends CachingFileSystem {
    private static final int BUFFER_SIZE = 65536;
    private final boolean cacheValidationEnabled;
    private LocalCacheFileSystem localCacheFileSystem;

    public AlluxioCachingFileSystem(ExtendedFileSystem dataTier, URI uri) {
        this(dataTier, uri, false);
    }

    public AlluxioCachingFileSystem(ExtendedFileSystem dataTier, URI uri, boolean cacheValidationEnabled) {
        super(dataTier, uri);
        this.cacheValidationEnabled = cacheValidationEnabled;
    }

    @Override
    public synchronized void initialize(URI uri, Configuration configuration) throws IOException {
        this.localCacheFileSystem = new LocalCacheFileSystem((FileSystem)this.dataTier);
        this.localCacheFileSystem.initialize(uri, configuration);
    }

    @Override
    public FSDataInputStream openFile(Path path, HiveFileContext hiveFileContext) throws Exception {
        if (hiveFileContext.isCacheable()) {
            FileStatus fileStatus = this.dataTier.getFileStatus(path);
            AlluxioURIStatus alluxioURIStatus = new AlluxioURIStatus(fileStatus, hiveFileContext);
            FSDataInputStream cachingInputStream = this.localCacheFileSystem.open((URIStatus)alluxioURIStatus, 65536);
            if (this.cacheValidationEnabled) {
                return new CacheValidatingInputStream(cachingInputStream, this.dataTier.openFile(path, hiveFileContext));
            }
            return cachingInputStream;
        }
        return this.dataTier.openFile(path, hiveFileContext);
    }
}

