/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import alluxio.client.file.FileInStream;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;

public class AlluxioCachingInputStream
extends FileInStream {
    private final FSDataInputStream input;

    public AlluxioCachingInputStream(FSDataInputStream input) {
        this.input = Objects.requireNonNull(input, "input is null");
    }

    public int read(byte[] bytes) throws IOException {
        return this.input.read(bytes);
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.input.read(bytes, offset, length);
    }

    public long skip(long length) throws IOException {
        return this.input.skip(length);
    }

    public int available() throws IOException {
        return this.input.available();
    }

    public void close() throws IOException {
        this.input.close();
    }

    public synchronized void mark(int limit) {
        this.input.mark(limit);
    }

    public synchronized void reset() throws IOException {
        this.input.reset();
    }

    public boolean markSupported() {
        return this.input.markSupported();
    }

    public void seek(long position) throws IOException {
        this.input.seek(position);
    }

    public long getPos() throws IOException {
        return this.input.getPos();
    }

    public long remaining() {
        throw new UnsupportedOperationException("Remaining is not supported");
    }

    public int positionedRead(long position, byte[] buffer, int offset, int length) throws IOException {
        return this.input.read(position, buffer, offset, length);
    }

    public int read() throws IOException {
        return this.input.read();
    }
}

