/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.CacheType;
import com.facebook.presto.cache.alluxio.AlluxioCachingFileSystem;
import com.facebook.presto.cache.filemerge.FileMergeCachingFileSystem;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public class CacheFactory {
    public ExtendedFileSystem createCachingFileSystem(Configuration factoryConfig, URI factoryUri, ExtendedFileSystem fileSystem, CacheManager cacheManager, boolean cachingEnabled, CacheType cacheType, boolean validationEnabled) throws IOException {
        if (!cachingEnabled) {
            return fileSystem;
        }
        Preconditions.checkState((cacheType != null ? 1 : 0) != 0);
        switch (cacheType) {
            case FILE_MERGE: {
                return new FileMergeCachingFileSystem(factoryUri, factoryConfig, cacheManager, fileSystem, validationEnabled);
            }
            case ALLUXIO: {
                AlluxioCachingFileSystem cachingFileSystem = new AlluxioCachingFileSystem(fileSystem, factoryUri);
                cachingFileSystem.initialize(factoryUri, factoryConfig);
                return cachingFileSystem;
            }
        }
        throw new IllegalArgumentException("Invalid CacheType: " + cacheType.name());
    }
}

