/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.filemerge;

import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.CachingFileSystem;
import com.facebook.presto.cache.filemerge.FileMergeCachingInputStream;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import java.net.URI;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;

public final class FileMergeCachingFileSystem
extends CachingFileSystem {
    private final CacheManager cacheManager;
    private final boolean cacheValidationEnabled;

    public FileMergeCachingFileSystem(URI uri, Configuration configuration, CacheManager cacheManager, ExtendedFileSystem dataTier, boolean cacheValidationEnabled) {
        super(dataTier, uri);
        Objects.requireNonNull(configuration, "configuration is null");
        this.cacheManager = Objects.requireNonNull(cacheManager, "cacheManager is null");
        this.cacheValidationEnabled = cacheValidationEnabled;
        this.setConf(configuration);
        this.statistics = FileMergeCachingFileSystem.getStatistics((String)this.uri.getScheme(), ((Object)((Object)this)).getClass());
    }

    @Override
    public FSDataInputStream openFile(Path path, HiveFileContext hiveFileContext) throws Exception {
        if (hiveFileContext.isCacheable()) {
            return new FileMergeCachingInputStream(this.dataTier.openFile(path, hiveFileContext), this.cacheManager, path, this.cacheValidationEnabled);
        }
        return this.dataTier.openFile(path, hiveFileContext);
    }

    public boolean isCacheValidationEnabled() {
        return this.cacheValidationEnabled;
    }
}

