/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

public class CacheConfig {
    private URI baseDirectory;
    private boolean validationEnabled;
    private DataSize maxInMemoryCacheSize = new DataSize(2.0, DataSize.Unit.GIGABYTE);
    private int maxCachedEntries = 1000;
    private Duration cacheTtl = new Duration(2.0, TimeUnit.DAYS);

    public URI getBaseDirectory() {
        return this.baseDirectory;
    }

    @Config(value="cache.base-directory")
    @ConfigDescription(value="Base URI to cache data")
    public CacheConfig setBaseDirectory(URI dataURI) {
        this.baseDirectory = dataURI;
        return this;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    @Config(value="cache.validation-enabled")
    @ConfigDescription(value="Enable cache validation by comparing with actual data with cached data")
    public CacheConfig setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
        return this;
    }

    public DataSize getMaxInMemoryCacheSize() {
        return this.maxInMemoryCacheSize;
    }

    @Config(value="cache.max-in-memory-cache-size")
    @ConfigDescription(value="The maximum cache size allowed in memory")
    public CacheConfig setMaxInMemoryCacheSize(DataSize maxInMemoryCacheSize) {
        this.maxInMemoryCacheSize = maxInMemoryCacheSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxCachedEntries() {
        return this.maxCachedEntries;
    }

    @Config(value="cache.max-cached-entries")
    @ConfigDescription(value="Number of entries allowed in the cache")
    public CacheConfig setMaxCachedEntries(int maxCachedEntries) {
        this.maxCachedEntries = maxCachedEntries;
        return this;
    }

    @MinDuration(value="0s")
    public Duration getCacheTtl() {
        return this.cacheTtl;
    }

    @Config(value="cache.ttl")
    @ConfigDescription(value="Time-to-live for a cache entry")
    public CacheConfig setCacheTtl(Duration cacheTtl) {
        this.cacheTtl = cacheTtl;
        return this;
    }
}

