/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.FileReadRequest;
import com.google.common.base.Verify;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;

final class CachingInputStream
extends FSDataInputStream {
    private final FSDataInputStream inputStream;
    private final CacheManager cacheManager;
    private final Path path;
    private final boolean cacheValidationEnabled;

    public CachingInputStream(FSDataInputStream inputStream, CacheManager cacheManager, Path path, boolean cacheValidationEnabled) {
        super((InputStream)inputStream);
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
        this.cacheManager = Objects.requireNonNull(cacheManager, "cacheManager is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.cacheValidationEnabled = cacheValidationEnabled;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        FileReadRequest key = new FileReadRequest(this.path, position, length);
        if (!this.cacheManager.get(key, buffer, offset)) {
            this.inputStream.readFully(position, buffer, offset, length);
            this.cacheManager.put(key, Slices.wrappedBuffer((byte[])buffer, (int)offset, (int)length));
            return;
        }
        if (this.cacheValidationEnabled) {
            byte[] validationBuffer = new byte[length];
            this.inputStream.readFully(position, validationBuffer, 0, length);
            for (int i = 0; i < length; ++i) {
                Verify.verify((buffer[offset + i] == validationBuffer[i] ? 1 : 0) != 0, (String)("corrupted buffer at position " + i), (Object[])new Object[0]);
            }
        }
    }
}

