/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.FieldInstruction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class GetFieldBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final ParameterizedType declaringClass;
    private final String name;

    public GetFieldBytecodeExpression(@Nullable BytecodeExpression instance, Class<?> declaringClass, String name) {
        this(instance, GetFieldBytecodeExpression.getDeclaredField(declaringClass, name));
    }

    public GetFieldBytecodeExpression(@Nullable BytecodeExpression instance, Field field) {
        this(instance, ParameterizedType.type(Objects.requireNonNull(field, "field is null").getDeclaringClass()), field.getName(), ParameterizedType.type(field.getType()));
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (instance == null) {
            Preconditions.checkArgument((boolean)isStatic, (String)"Field is not static: %s", (Object)field);
        } else {
            Preconditions.checkArgument((!isStatic ? 1 : 0) != 0, (String)"Field is static: %s", (Object)field);
        }
    }

    public GetFieldBytecodeExpression(@Nullable BytecodeExpression instance, FieldDefinition field) {
        this(instance, Objects.requireNonNull(field, "field is null").getDeclaringClass().getType(), field.getName(), field.getType());
        if (instance == null) {
            Preconditions.checkArgument((boolean)field.getAccess().contains((Object)Access.STATIC), (String)"Field is not static: %s", (Object)field);
        } else {
            Preconditions.checkArgument((!field.getAccess().contains((Object)Access.STATIC) ? 1 : 0) != 0, (String)"Field is static: %s", (Object)field);
        }
    }

    public GetFieldBytecodeExpression(@Nullable BytecodeExpression instance, ParameterizedType declaringClass, String name, ParameterizedType type) {
        super(type);
        Preconditions.checkArgument((instance == null || !instance.getType().isPrimitive() ? 1 : 0) != 0, (String)"Type %s does not have fields", (Object)this.getType());
        this.instance = instance;
        this.declaringClass = Objects.requireNonNull(declaringClass, "declaringClass is null");
        this.name = Objects.requireNonNull(name, "name is null");
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        if (this.instance == null) {
            return FieldInstruction.getStaticInstruction(this.declaringClass, this.name, this.getType());
        }
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).getField(this.declaringClass, this.name, this.getType());
    }

    @Override
    protected String formatOneLine() {
        if (this.instance == null) {
            return this.declaringClass.getSimpleName() + "." + this.name;
        }
        return this.instance + "." + this.name;
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return this.instance == null ? ImmutableList.of() : ImmutableList.of((Object)this.instance);
    }

    private static Field getDeclaredField(Class<?> declaringClass, String name) {
        Objects.requireNonNull(declaringClass, "declaringClass is null");
        Objects.requireNonNull(name, "name is null");
        try {
            return declaringClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("Class %s does not have a '%s' field", declaringClass.getName(), name));
        }
    }
}

