/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.DumpBytecodeVisitor;
import com.facebook.presto.bytecode.ParameterizedType;
import com.google.common.base.CharMatcher;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public final class BytecodeUtils {
    private static final AtomicLong CLASS_ID = new AtomicLong();
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("YYYYMMdd_HHmmss");

    private BytecodeUtils() {
    }

    public static ParameterizedType makeClassName(String baseName, Optional<String> suffix) {
        String className = baseName + "_" + suffix.orElseGet(() -> Instant.now().atZone(ZoneOffset.UTC).format(TIMESTAMP_FORMAT)) + "_" + CLASS_ID.incrementAndGet();
        String javaClassName = BytecodeUtils.toJavaIdentifierString(className);
        return ParameterizedType.typeFromJavaClassName("com.facebook.presto.$gen." + javaClassName);
    }

    public static ParameterizedType makeClassName(String baseName) {
        return BytecodeUtils.makeClassName(baseName, Optional.empty());
    }

    public static String toJavaIdentifierString(String className) {
        return CharMatcher.forPredicate(Character::isJavaIdentifierPart).negate().replaceFrom((CharSequence)className, '_');
    }

    public static String dumpBytecodeTree(ClassDefinition classDefinition) {
        StringWriter writer = new StringWriter();
        new DumpBytecodeVisitor(writer).visitClass(classDefinition);
        return writer.toString();
    }
}

