/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.util.List;
import java.util.Objects;

public class CastBytecodeExpression
extends BytecodeExpression {
    private static final ParameterizedType OBJECT_TYPE = ParameterizedType.type(Object.class);
    private final BytecodeExpression instance;

    public CastBytecodeExpression(BytecodeExpression instance, ParameterizedType type) {
        super(type);
        this.instance = Objects.requireNonNull(instance, "instance is null");
        Preconditions.checkArgument((type.getPrimitiveType() != Void.TYPE ? 1 : 0) != 0, (String)"Type %s can not be cast to %s", (Object)instance.getType(), (Object)type);
        CastBytecodeExpression.generateBytecode(instance.getType(), this.getType());
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(CastBytecodeExpression.generateBytecode(this.instance.getType(), this.getType()));
    }

    private static BytecodeBlock generateBytecode(ParameterizedType sourceType, ParameterizedType targetType) {
        BytecodeBlock block = new BytecodeBlock();
        switch (CastBytecodeExpression.getTypeKind(sourceType)) {
            case PRIMITIVE: {
                switch (CastBytecodeExpression.getTypeKind(targetType)) {
                    case PRIMITIVE: {
                        CastBytecodeExpression.castPrimitiveToPrimitive(block, sourceType.getPrimitiveType(), targetType.getPrimitiveType());
                        return block;
                    }
                    case BOXED_PRIMITIVE: {
                        Preconditions.checkArgument((sourceType.getPrimitiveType() == CastBytecodeExpression.unwrapPrimitiveType(targetType) ? 1 : 0) != 0, (String)"Type %s can not be cast to %s", (Object)sourceType, (Object)targetType);
                        return block.invokeStatic(targetType, "valueOf", targetType, sourceType);
                    }
                    case OTHER: {
                        Preconditions.checkArgument((boolean)OBJECT_TYPE.equals(targetType), (String)"Type %s can not be cast to %s", (Object)sourceType, (Object)targetType);
                        Class<?> sourceClass = sourceType.getPrimitiveType();
                        return block.invokeStatic(Primitives.wrap(sourceClass), "valueOf", Primitives.wrap(sourceClass), sourceClass).checkCast(targetType);
                    }
                }
            }
            case BOXED_PRIMITIVE: {
                switch (CastBytecodeExpression.getTypeKind(targetType)) {
                    case PRIMITIVE: {
                        Preconditions.checkArgument((CastBytecodeExpression.unwrapPrimitiveType(sourceType) == targetType.getPrimitiveType() ? 1 : 0) != 0, (String)"Type %s can not be cast to %s", (Object)sourceType, (Object)targetType);
                        return block.invokeVirtual(sourceType, targetType.getPrimitiveType().getSimpleName() + "Value", targetType, new ParameterizedType[0]);
                    }
                    case BOXED_PRIMITIVE: {
                        Preconditions.checkArgument((boolean)sourceType.equals(targetType), (String)"Type %s can not be cast to %s", (Object)sourceType, (Object)targetType);
                        return block;
                    }
                    case OTHER: {
                        return block.checkCast(targetType);
                    }
                }
            }
            case OTHER: {
                switch (CastBytecodeExpression.getTypeKind(targetType)) {
                    case PRIMITIVE: {
                        Preconditions.checkArgument((boolean)OBJECT_TYPE.equals(sourceType), (String)"Type %s can not be cast to %s", (Object)sourceType, (Object)targetType);
                        return block.checkCast(Primitives.wrap(targetType.getPrimitiveType())).invokeVirtual(Primitives.wrap(targetType.getPrimitiveType()), targetType.getPrimitiveType().getSimpleName() + "Value", targetType.getPrimitiveType(), new Class[0]);
                    }
                    case BOXED_PRIMITIVE: 
                    case OTHER: {
                        return block.checkCast(targetType);
                    }
                }
            }
        }
        throw new UnsupportedOperationException("unexpected enum value");
    }

    private static BytecodeBlock castPrimitiveToPrimitive(BytecodeBlock block, Class<?> sourceType, Class<?> targetType) {
        if (sourceType == Boolean.TYPE && targetType == Boolean.TYPE) {
            return block;
        }
        if (sourceType == Byte.TYPE) {
            if (targetType == Byte.TYPE) {
                return block;
            }
            if (targetType == Character.TYPE) {
                return block;
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Character.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block;
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Short.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Integer.TYPE) {
            if (targetType == Boolean.TYPE) {
                return block;
            }
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Long.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.L2I);
            }
            if (targetType == Long.TYPE) {
                return block;
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.L2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.L2D);
            }
        }
        if (sourceType == Float.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.F2I);
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.F2L);
            }
            if (targetType == Float.TYPE) {
                return block;
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.F2D);
            }
        }
        if (sourceType == Double.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.D2I);
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.D2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.D2F);
            }
            if (targetType == Double.TYPE) {
                return block;
            }
        }
        throw new IllegalArgumentException(String.format("Type %s can not be cast to %s", sourceType, targetType));
    }

    private static TypeKind getTypeKind(ParameterizedType type) {
        if (type.isPrimitive()) {
            return TypeKind.PRIMITIVE;
        }
        if (CastBytecodeExpression.unwrapPrimitiveType(type) != null) {
            return TypeKind.BOXED_PRIMITIVE;
        }
        return TypeKind.OTHER;
    }

    private static Class<?> unwrapPrimitiveType(ParameterizedType boxedPrimitiveType) {
        switch (boxedPrimitiveType.getJavaClassName()) {
            case "java.lang.Boolean": {
                return Boolean.TYPE;
            }
            case "java.lang.Byte": {
                return Byte.TYPE;
            }
            case "java.lang.Character": {
                return Character.TYPE;
            }
            case "java.lang.Short": {
                return Short.TYPE;
            }
            case "java.lang.Integer": {
                return Integer.TYPE;
            }
            case "java.lang.Long": {
                return Long.TYPE;
            }
            case "java.lang.Float": {
                return Float.TYPE;
            }
            case "java.lang.Double": {
                return Double.TYPE;
            }
        }
        return null;
    }

    @Override
    protected String formatOneLine() {
        return "((" + this.getType().getSimpleName() + ") " + this.instance + ")";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.instance);
    }

    private static enum TypeKind {
        PRIMITIVE,
        BOXED_PRIMITIVE,
        OTHER;

    }
}

