/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.Binding;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.CastBytecodeExpression;
import com.facebook.presto.bytecode.instruction.InvokeInstruction;
import io.airlift.slice.Slice;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class StaticTypeBytecodeExpression
extends BytecodeExpression {
    private final String typeName;
    private final Class<?> javaType;
    private final Binding binding;
    private final Method bootstrapMethod;

    public StaticTypeBytecodeExpression(Binding binding, Method bootstrapMethod, Class<?> sqlType, String typeName, Class<?> javaType) {
        super(ParameterizedType.type(sqlType));
        this.typeName = Objects.requireNonNull(typeName, "type is null");
        this.javaType = javaType;
        this.binding = Objects.requireNonNull(binding, "binding is null");
        this.bootstrapMethod = Objects.requireNonNull(bootstrapMethod, "bootstrapMethod is null");
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return InvokeInstruction.invokeDynamic(this.typeName.replaceAll("\\W+", "_"), this.binding.getType(), this.bootstrapMethod, this.binding.getBindingId());
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return Collections.emptyList();
    }

    @Override
    protected String formatOneLine() {
        return this.typeName;
    }

    public BytecodeExpression getValue(BytecodeExpression block, BytecodeExpression position) {
        if (this.javaType == Boolean.TYPE) {
            return this.invoke("getBoolean", Boolean.TYPE, block, position);
        }
        if (this.javaType == Long.TYPE) {
            return this.invoke("getLong", Long.TYPE, block, position);
        }
        if (this.javaType == Double.TYPE) {
            return this.invoke("getDouble", Double.TYPE, block, position);
        }
        if (this.javaType == Slice.class) {
            return this.invoke("getSlice", Slice.class, block, position);
        }
        return this.invoke("getObject", Object.class, block, position).cast(this.javaType);
    }

    public BytecodeExpression writeValue(BytecodeExpression blockBuilder, BytecodeExpression value) {
        if (this.javaType == Boolean.TYPE) {
            return this.invoke("writeBoolean", Void.TYPE, blockBuilder, value);
        }
        if (this.javaType == Long.TYPE) {
            return this.invoke("writeLong", Void.TYPE, blockBuilder, value);
        }
        if (this.javaType == Double.TYPE) {
            return this.invoke("writeDouble", Void.TYPE, blockBuilder, value);
        }
        if (this.javaType == Slice.class) {
            return this.invoke("writeSlice", Void.TYPE, blockBuilder, value);
        }
        return this.invoke("writeObject", Void.TYPE, blockBuilder, value.cast(Object.class));
    }

    public BytecodeExpression writeValueWithCast(BytecodeExpression blockBuilder, BytecodeExpression value) {
        if (this.javaType == Boolean.TYPE) {
            return this.invoke("writeBoolean", Void.TYPE, blockBuilder, value);
        }
        if (this.javaType == Long.TYPE) {
            return this.invoke("writeLong", Void.TYPE, blockBuilder, new CastBytecodeExpression(value, ParameterizedType.type(Long.TYPE)));
        }
        if (this.javaType == Double.TYPE) {
            return this.invoke("writeDouble", Void.TYPE, blockBuilder, new CastBytecodeExpression(value, ParameterizedType.type(Double.TYPE)));
        }
        if (this.javaType == Slice.class) {
            return this.invoke("writeSlice", Void.TYPE, blockBuilder, value);
        }
        return this.invoke("writeObject", Void.TYPE, blockBuilder, value.cast(Object.class));
    }
}

