/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.AndBytecodeExpression;
import com.facebook.presto.bytecode.expression.ArithmeticBytecodeExpression;
import com.facebook.presto.bytecode.expression.ArrayLengthBytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.ComparisonBytecodeExpression;
import com.facebook.presto.bytecode.expression.ConstantBytecodeExpression;
import com.facebook.presto.bytecode.expression.GetElementBytecodeExpression;
import com.facebook.presto.bytecode.expression.GetFieldBytecodeExpression;
import com.facebook.presto.bytecode.expression.InlineIfBytecodeExpression;
import com.facebook.presto.bytecode.expression.InvokeBytecodeExpression;
import com.facebook.presto.bytecode.expression.InvokeDynamicBytecodeExpression;
import com.facebook.presto.bytecode.expression.NegateBytecodeExpression;
import com.facebook.presto.bytecode.expression.NewArrayBytecodeExpression;
import com.facebook.presto.bytecode.expression.NewInstanceBytecodeExpression;
import com.facebook.presto.bytecode.expression.NotBytecodeExpression;
import com.facebook.presto.bytecode.expression.OrBytecodeExpression;
import com.facebook.presto.bytecode.expression.SetArrayElementBytecodeExpression;
import com.facebook.presto.bytecode.expression.SetFieldBytecodeExpression;
import com.facebook.presto.bytecode.instruction.Constant;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

public final class BytecodeExpressions {
    private BytecodeExpressions() {
    }

    public static BytecodeExpression constantTrue() {
        return new ConstantBytecodeExpression(Boolean.TYPE, Constant.loadBoolean(true));
    }

    public static BytecodeExpression constantFalse() {
        return new ConstantBytecodeExpression(Boolean.TYPE, Constant.loadBoolean(false));
    }

    public static BytecodeExpression constantBoolean(boolean value) {
        return new ConstantBytecodeExpression(Boolean.TYPE, Constant.loadBoolean(value));
    }

    public static BytecodeExpression constantClass(Class<?> value) {
        return new ConstantBytecodeExpression(Class.class, Constant.loadClass(value));
    }

    public static BytecodeExpression constantClass(ParameterizedType value) {
        return new ConstantBytecodeExpression(Class.class, Constant.loadClass(value));
    }

    public static BytecodeExpression constantDouble(double value) {
        return new ConstantBytecodeExpression(Double.TYPE, Constant.loadDouble(value));
    }

    public static BytecodeExpression constantFloat(float value) {
        return new ConstantBytecodeExpression(Float.TYPE, Constant.loadFloat(value));
    }

    public static BytecodeExpression constantInt(int value) {
        return new ConstantBytecodeExpression(Integer.TYPE, Constant.loadInt(value));
    }

    public static BytecodeExpression constantLong(long value) {
        return new ConstantBytecodeExpression(Long.TYPE, Constant.loadLong(value));
    }

    public static BytecodeExpression constantNumber(Number value) {
        if (value instanceof Byte) {
            return BytecodeExpressions.constantInt(value.intValue()).cast(Byte.TYPE);
        }
        if (value instanceof Short) {
            return BytecodeExpressions.constantInt(value.intValue()).cast(Short.TYPE);
        }
        if (value instanceof Integer) {
            return BytecodeExpressions.constantInt((Integer)value);
        }
        if (value instanceof Long) {
            return BytecodeExpressions.constantLong((Long)value);
        }
        if (value instanceof Float) {
            return BytecodeExpressions.constantFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return BytecodeExpressions.constantDouble((Double)value);
        }
        throw new IllegalStateException("Unsupported number type " + value.getClass().getSimpleName());
    }

    public static BytecodeExpression constantNull(Class<?> type) {
        return new ConstantBytecodeExpression(type, Constant.loadNull());
    }

    public static BytecodeExpression constantNull(ParameterizedType type) {
        return new ConstantBytecodeExpression(type, Constant.loadNull());
    }

    public static BytecodeExpression constantString(String value) {
        return new ConstantBytecodeExpression(String.class, Constant.loadString(value));
    }

    public static BytecodeExpression defaultValue(ParameterizedType type) {
        if (type.isPrimitive()) {
            return BytecodeExpressions.defaultValue(type.getPrimitiveType());
        }
        return BytecodeExpressions.constantNull(type);
    }

    public static BytecodeExpression defaultValue(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        if (type == Boolean.TYPE) {
            return BytecodeExpressions.constantInt(0).cast(Boolean.TYPE);
        }
        if (type == Byte.TYPE) {
            return BytecodeExpressions.constantInt(0).cast(Byte.TYPE);
        }
        if (type == Integer.TYPE) {
            return BytecodeExpressions.constantInt(0);
        }
        if (type == Short.TYPE) {
            return BytecodeExpressions.constantInt(0).cast(Short.TYPE);
        }
        if (type == Long.TYPE) {
            return BytecodeExpressions.constantLong(0L);
        }
        if (type == Float.TYPE) {
            return BytecodeExpressions.constantFloat(0.0f);
        }
        if (type == Double.TYPE) {
            return BytecodeExpressions.constantDouble(0.0);
        }
        Preconditions.checkArgument((!type.isPrimitive() ? 1 : 0) != 0, (String)"Unsupported type %s", type);
        return BytecodeExpressions.constantNull(type);
    }

    public static BytecodeExpression getStatic(Class<?> declaringClass, String name) {
        return new GetFieldBytecodeExpression(null, declaringClass, name);
    }

    public static BytecodeExpression getStatic(Field staticField) {
        return new GetFieldBytecodeExpression(null, staticField);
    }

    public static BytecodeExpression getStatic(FieldDefinition staticField) {
        return new GetFieldBytecodeExpression(null, staticField);
    }

    public static BytecodeExpression getStatic(ParameterizedType declaringClass, String name, ParameterizedType type) {
        return new GetFieldBytecodeExpression(null, declaringClass, name, type);
    }

    public static BytecodeExpression setStatic(Class<?> declaringClass, String name, BytecodeExpression value) {
        return new SetFieldBytecodeExpression(null, declaringClass, name, value);
    }

    public static BytecodeExpression setStatic(Field staticField, BytecodeExpression value) {
        return new SetFieldBytecodeExpression(null, staticField, value);
    }

    public static BytecodeExpression setStatic(FieldDefinition staticField, BytecodeExpression value) {
        return new SetFieldBytecodeExpression(null, staticField, value);
    }

    public static BytecodeExpression setStatic(ParameterizedType declaringClass, String name, BytecodeExpression value) {
        return new SetFieldBytecodeExpression(null, declaringClass, name, value);
    }

    public static BytecodeExpression newInstance(Class<?> returnType, BytecodeExpression ... parameters) {
        return BytecodeExpressions.newInstance(ParameterizedType.type(returnType), (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static BytecodeExpression newInstance(Class<?> returnType, Iterable<? extends BytecodeExpression> parameters) {
        return BytecodeExpressions.newInstance(ParameterizedType.type(returnType), parameters);
    }

    public static BytecodeExpression newInstance(ParameterizedType returnType, BytecodeExpression ... parameters) {
        Objects.requireNonNull(parameters, "parameters is null");
        return BytecodeExpressions.newInstance(returnType, (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    public static BytecodeExpression newInstance(ParameterizedType returnType, Iterable<? extends BytecodeExpression> parameters) {
        Objects.requireNonNull(parameters, "parameters is null");
        return BytecodeExpressions.newInstance(returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform(parameters, BytecodeExpression::getType)), parameters);
    }

    public static BytecodeExpression newInstance(Class<?> returnType, Iterable<? extends Class<?>> parameterTypes, BytecodeExpression ... parameters) {
        return BytecodeExpressions.newInstance(ParameterizedType.type(returnType), (Iterable<ParameterizedType>)Iterables.transform(parameterTypes, ParameterizedType::type), (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static BytecodeExpression newInstance(ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, BytecodeExpression ... parameters) {
        return BytecodeExpressions.newInstance(returnType, parameterTypes, (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static BytecodeExpression newInstance(ParameterizedType type, Iterable<ParameterizedType> parameterTypes, Iterable<? extends BytecodeExpression> parameters) {
        return new NewInstanceBytecodeExpression(type, parameterTypes, parameters);
    }

    public static BytecodeExpression newArray(ParameterizedType type, int length) {
        return new NewArrayBytecodeExpression(type, length);
    }

    public static BytecodeExpression newArray(ParameterizedType type, BytecodeExpression length) {
        return new NewArrayBytecodeExpression(type, length);
    }

    public static BytecodeExpression newArray(ParameterizedType type, Iterable<? extends BytecodeExpression> elements) {
        return new NewArrayBytecodeExpression(type, (List<BytecodeExpression>)ImmutableList.copyOf(elements));
    }

    public static BytecodeExpression length(BytecodeExpression instance) {
        return new ArrayLengthBytecodeExpression(instance);
    }

    public static BytecodeExpression get(BytecodeExpression instance, BytecodeExpression index) {
        return new GetElementBytecodeExpression(instance, index);
    }

    public static BytecodeExpression set(BytecodeExpression instance, BytecodeExpression index, BytecodeExpression value) {
        return new SetArrayElementBytecodeExpression(instance, index, value);
    }

    public static BytecodeExpression invokeStatic(MethodDefinition method, BytecodeExpression ... parameters) {
        return BytecodeExpressions.invokeStatic(method.getDeclaringClass().getType(), method.getName(), method.getReturnType(), (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    public static BytecodeExpression invokeStatic(Method method, BytecodeExpression ... parameters) {
        return BytecodeExpressions.invokeStatic(method, (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static BytecodeExpression invokeStatic(Method method, Iterable<? extends BytecodeExpression> parameters) {
        return BytecodeExpressions.invokeStatic(method.getDeclaringClass(), method.getName(), method.getReturnType(), parameters);
    }

    public static BytecodeExpression invokeStatic(Class<?> methodTargetType, String methodName, Class<?> returnType, BytecodeExpression ... parameters) {
        return BytecodeExpressions.invokeStatic(methodTargetType, methodName, returnType, (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static BytecodeExpression invokeStatic(Class<?> methodTargetType, String methodName, Class<?> returnType, Iterable<? extends BytecodeExpression> parameters) {
        return BytecodeExpressions.invokeStatic(ParameterizedType.type(methodTargetType), methodName, ParameterizedType.type(returnType), parameters);
    }

    public static BytecodeExpression invokeStatic(ParameterizedType methodTargetType, String methodName, ParameterizedType returnType, Iterable<? extends BytecodeExpression> parameters) {
        Objects.requireNonNull(methodTargetType, "methodTargetType is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(parameters, "parameters is null");
        return BytecodeExpressions.invokeStatic(methodTargetType, methodName, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform(parameters, BytecodeExpression::getType)), parameters);
    }

    public static BytecodeExpression invokeStatic(Class<?> methodTargetType, String methodName, Class<?> returnType, Iterable<? extends Class<?>> parameterTypes, BytecodeExpression ... parameters) {
        Objects.requireNonNull(methodTargetType, "methodTargetType is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(parameterTypes, "parameterTypes is null");
        Objects.requireNonNull(parameters, "parameters is null");
        return BytecodeExpressions.invokeStatic(ParameterizedType.type(methodTargetType), methodName, ParameterizedType.type(returnType), (Iterable<ParameterizedType>)Iterables.transform(parameterTypes, ParameterizedType::type), (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    public static BytecodeExpression invokeStatic(ParameterizedType methodTargetType, String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, BytecodeExpression ... parameters) {
        return BytecodeExpressions.invokeStatic(methodTargetType, methodName, returnType, parameterTypes, (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static BytecodeExpression invokeStatic(ParameterizedType methodTargetType, String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Iterable<? extends BytecodeExpression> parameters) {
        return new InvokeBytecodeExpression(null, methodTargetType, methodName, returnType, parameterTypes, parameters);
    }

    public static BytecodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, Class<?> returnType, BytecodeExpression ... parameters) {
        return BytecodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, returnType, (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static BytecodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, Class<?> returnType, Iterable<? extends BytecodeExpression> parameters) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(parameters, "parameters is null");
        return BytecodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, ParameterizedType.type(returnType), (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform(parameters, BytecodeExpression::getType)), parameters);
    }

    public static BytecodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, ParameterizedType returnType, BytecodeExpression ... parameters) {
        return BytecodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, returnType, (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static BytecodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, ParameterizedType returnType, Iterable<? extends BytecodeExpression> parameters) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(parameters, "parameters is null");
        return BytecodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform(parameters, BytecodeExpression::getType)), parameters);
    }

    public static BytecodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, MethodType methodType, BytecodeExpression ... parameters) {
        Objects.requireNonNull(methodType, "methodType is null");
        Objects.requireNonNull(parameters, "parameters is null");
        return BytecodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, methodType, (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    public static BytecodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, MethodType methodType, Iterable<? extends BytecodeExpression> parameters) {
        return BytecodeExpressions.invokeDynamic(bootstrapMethod, bootstrapArgs, methodName, ParameterizedType.type(methodType.returnType()), Iterables.transform(methodType.parameterList(), ParameterizedType::type), (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf(Objects.requireNonNull(parameters, "parameters is null")));
    }

    public static BytecodeExpression invokeDynamic(Method bootstrapMethod, Iterable<? extends Object> bootstrapArgs, String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Iterable<? extends BytecodeExpression> parameters) {
        return new InvokeDynamicBytecodeExpression(bootstrapMethod, bootstrapArgs, methodName, returnType, parameters, parameterTypes);
    }

    public static BytecodeExpression add(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.IADD, left, right);
    }

    public static BytecodeExpression subtract(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.ISUB, left, right);
    }

    public static BytecodeExpression multiply(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.IMUL, left, right);
    }

    public static BytecodeExpression divide(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.IDIV, left, right);
    }

    public static BytecodeExpression remainder(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.IREM, left, right);
    }

    public static BytecodeExpression bitwiseAnd(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.IAND, left, right);
    }

    public static BytecodeExpression bitwiseOr(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.IOR, left, right);
    }

    public static BytecodeExpression bitwiseXor(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.IXOR, left, right);
    }

    public static BytecodeExpression shiftLeft(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.ISHL, left, right);
    }

    public static BytecodeExpression shiftRight(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.ISHR, left, right);
    }

    public static BytecodeExpression shiftRightUnsigned(BytecodeExpression left, BytecodeExpression right) {
        return ArithmeticBytecodeExpression.createArithmeticBytecodeExpression(OpCode.IUSHR, left, right);
    }

    public static BytecodeExpression negate(BytecodeExpression value) {
        return new NegateBytecodeExpression(value);
    }

    public static BytecodeExpression lessThan(BytecodeExpression left, BytecodeExpression right) {
        return ComparisonBytecodeExpression.lessThan(left, right);
    }

    public static BytecodeExpression greaterThan(BytecodeExpression left, BytecodeExpression right) {
        return ComparisonBytecodeExpression.greaterThan(left, right);
    }

    public static BytecodeExpression lessThanOrEqual(BytecodeExpression left, BytecodeExpression right) {
        return ComparisonBytecodeExpression.lessThanOrEqual(left, right);
    }

    public static BytecodeExpression greaterThanOrEqual(BytecodeExpression left, BytecodeExpression right) {
        return ComparisonBytecodeExpression.greaterThanOrEqual(left, right);
    }

    public static BytecodeExpression equal(BytecodeExpression left, BytecodeExpression right) {
        return ComparisonBytecodeExpression.equal(left, right);
    }

    public static BytecodeExpression notEqual(BytecodeExpression left, BytecodeExpression right) {
        return ComparisonBytecodeExpression.notEqual(left, right);
    }

    public static BytecodeExpression and(BytecodeExpression left, BytecodeExpression right) {
        return new AndBytecodeExpression(left, right);
    }

    public static BytecodeExpression or(BytecodeExpression left, BytecodeExpression right) {
        return new OrBytecodeExpression(left, right);
    }

    public static BytecodeExpression not(BytecodeExpression value) {
        return new NotBytecodeExpression(value);
    }

    public static BytecodeExpression inlineIf(BytecodeExpression condition, BytecodeExpression ifTrue, BytecodeExpression ifFalse) {
        return new InlineIfBytecodeExpression(condition, ifTrue, ifFalse);
    }

    public static BytecodeExpression print(BytecodeExpression variable) {
        BytecodeExpression out = BytecodeExpressions.getStatic(System.class, "out");
        return out.invoke("println", Void.TYPE, variable);
    }
}

