/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.AnnotationDefinition;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.Comment;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.CaseStatement;
import com.facebook.presto.bytecode.control.DoWhileLoop;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.control.LookupSwitch;
import com.facebook.presto.bytecode.control.TryCatch;
import com.facebook.presto.bytecode.control.WhileLoop;
import com.facebook.presto.bytecode.debug.LineNumberNode;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.Constant;
import com.facebook.presto.bytecode.instruction.InstructionNode;
import com.facebook.presto.bytecode.instruction.InvokeInstruction;
import com.facebook.presto.bytecode.instruction.JumpInstruction;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.bytecode.instruction.VariableInstruction;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DumpBytecodeVisitor
extends BytecodeVisitor<Void> {
    private final PrintStream out;
    private int indentLevel;
    private int lineNumber = -1;

    public DumpBytecodeVisitor(PrintStream out) {
        this.out = out;
    }

    @Override
    public Void visitClass(ClassDefinition classDefinition) {
        for (AnnotationDefinition annotationDefinition : classDefinition.getAnnotations()) {
            this.visitAnnotation(classDefinition, annotationDefinition);
        }
        Line classDeclaration = this.line().addAll(classDefinition.getAccess());
        if (!classDefinition.getAccess().contains((Object)Access.INTERFACE)) {
            classDeclaration.add("class");
        }
        classDeclaration.add(classDefinition.getType().getJavaClassName());
        if (!classDefinition.getSuperClass().equals(ParameterizedType.type(Object.class))) {
            classDeclaration.add("extends").add(classDefinition.getSuperClass().getJavaClassName());
        }
        if (!classDefinition.getInterfaces().isEmpty()) {
            classDeclaration.add("implements");
            for (ParameterizedType interfaceType : classDefinition.getInterfaces()) {
                classDeclaration.add(interfaceType.getJavaClassName());
            }
        }
        classDeclaration.print();
        this.printLine("{");
        ++this.indentLevel;
        for (FieldDefinition fieldDefinition : classDefinition.getFields()) {
            this.visitField(classDefinition, fieldDefinition);
        }
        for (MethodDefinition methodDefinition : classDefinition.getMethods()) {
            this.visitMethod(classDefinition, methodDefinition);
        }
        this.visitMethod(classDefinition, classDefinition.getClassInitializer());
        --this.indentLevel;
        this.printLine("}");
        this.printLine();
        return null;
    }

    @Override
    public Void visitAnnotation(Object parent, AnnotationDefinition annotationDefinition) {
        this.printLine("@%s", annotationDefinition.getType().getJavaClassName(), annotationDefinition.getValues());
        return null;
    }

    @Override
    public Void visitField(ClassDefinition classDefinition, FieldDefinition fieldDefinition) {
        for (AnnotationDefinition annotationDefinition : fieldDefinition.getAnnotations()) {
            this.visitAnnotation(fieldDefinition, annotationDefinition);
        }
        this.line().addAll((Collection<?>)fieldDefinition.getAccess()).add(fieldDefinition.getType().getJavaClassName()).add(fieldDefinition.getName()).add(";").print();
        this.printLine();
        return null;
    }

    @Override
    public Void visitMethod(ClassDefinition classDefinition, MethodDefinition methodDefinition) {
        if (methodDefinition.getComment() != null) {
            this.printLine("// %s", methodDefinition.getComment());
        }
        for (AnnotationDefinition annotationDefinition : methodDefinition.getAnnotations()) {
            this.visitAnnotation(methodDefinition, annotationDefinition);
        }
        this.printLine(methodDefinition.toSourceString());
        methodDefinition.getBody().accept(null, this);
        this.printLine();
        return null;
    }

    @Override
    public Void visitComment(BytecodeNode parent, Comment node) {
        this.printLine();
        this.printLine("// %s", node.getComment());
        return null;
    }

    @Override
    public Void visitBlock(BytecodeNode parent, BytecodeBlock block) {
        boolean indented;
        if (block.getDescription() != null) {
            this.line().add(block.getDescription()).add("{").print();
            ++this.indentLevel;
            indented = true;
        } else if (block.getChildNodes().size() > 1) {
            this.printLine("{");
            ++this.indentLevel;
            indented = true;
        } else {
            indented = false;
        }
        this.visitBlockContents(block);
        if (indented) {
            --this.indentLevel;
            this.printLine("}");
        }
        return null;
    }

    private void visitBlockContents(BytecodeBlock block) {
        for (BytecodeNode node : block.getChildNodes()) {
            if (node instanceof BytecodeBlock) {
                BytecodeBlock childBlock = (BytecodeBlock)node;
                if (childBlock.getDescription() != null) {
                    this.visitBlock(block, childBlock);
                    continue;
                }
                this.visitBlockContents(childBlock);
                continue;
            }
            node.accept(node, this);
        }
    }

    @Override
    public Void visitBytecodeExpression(BytecodeNode parent, BytecodeExpression expression) {
        this.printLine(expression.toString());
        return null;
    }

    @Override
    public Void visitNode(BytecodeNode parent, BytecodeNode node) {
        this.printLine(node.toString());
        super.visitNode(parent, node);
        return null;
    }

    @Override
    public Void visitLabel(BytecodeNode parent, LabelNode labelNode) {
        this.printLine("%s:", labelNode.getName());
        return null;
    }

    @Override
    public Void visitJumpInstruction(BytecodeNode parent, JumpInstruction jumpInstruction) {
        this.printLine("%s %s", jumpInstruction.getOpCode(), jumpInstruction.getLabel().getName());
        return null;
    }

    @Override
    public Void visitLoadVariable(BytecodeNode parent, VariableInstruction.LoadVariableInstruction loadVariableInstruction) {
        Variable variable = loadVariableInstruction.getVariable();
        this.printLine("load %s", variable.getName());
        return null;
    }

    @Override
    public Void visitStoreVariable(BytecodeNode parent, VariableInstruction.StoreVariableInstruction storeVariableInstruction) {
        Variable variable = storeVariableInstruction.getVariable();
        this.printLine("store %s)", variable.getName());
        return null;
    }

    @Override
    public Void visitIncrementVariable(BytecodeNode parent, VariableInstruction.IncrementVariableInstruction incrementVariableInstruction) {
        Variable variable = incrementVariableInstruction.getVariable();
        byte increment = incrementVariableInstruction.getIncrement();
        this.printLine("increment %s %s", variable.getName(), increment);
        return null;
    }

    @Override
    public Void visitInvoke(BytecodeNode parent, InvokeInstruction invokeInstruction) {
        this.printLine("invoke %s.%s%s", invokeInstruction.getTarget().getJavaClassName(), invokeInstruction.getName(), invokeInstruction.getMethodDescription());
        return null;
    }

    @Override
    public Void visitInvokeDynamic(BytecodeNode parent, InvokeInstruction.InvokeDynamicInstruction invokeDynamicInstruction) {
        this.printLine("invokeDynamic %s%s %s", invokeDynamicInstruction.getName(), invokeDynamicInstruction.getMethodDescription(), invokeDynamicInstruction.getBootstrapArguments());
        return null;
    }

    @Override
    public Void visitTryCatch(BytecodeNode parent, TryCatch tryCatch) {
        if (tryCatch.getComment() != null) {
            this.printLine();
            this.printLine("// %s", tryCatch.getComment());
        }
        this.printLine("try {");
        ++this.indentLevel;
        tryCatch.getTryNode().accept(tryCatch, this);
        --this.indentLevel;
        this.printLine("}");
        this.printLine("catch (%s) {", tryCatch.getExceptionName());
        ++this.indentLevel;
        tryCatch.getCatchNode().accept(tryCatch, this);
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    @Override
    public Void visitIf(BytecodeNode parent, IfStatement ifStatement) {
        if (ifStatement.getComment() != null) {
            this.printLine();
            this.printLine("// %s", ifStatement.getComment());
        }
        this.printLine("if {");
        ++this.indentLevel;
        this.visitNestedNode("condition", ifStatement.condition(), ifStatement);
        if (!ifStatement.ifTrue().isEmpty()) {
            this.visitNestedNode("ifTrue", ifStatement.ifTrue(), ifStatement);
        }
        if (!ifStatement.ifFalse().isEmpty()) {
            this.visitNestedNode("ifFalse", ifStatement.ifFalse(), ifStatement);
        }
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    @Override
    public Void visitFor(BytecodeNode parent, ForLoop forLoop) {
        if (forLoop.getComment() != null) {
            this.printLine();
            this.printLine("// %s", forLoop.getComment());
        }
        this.printLine("for {");
        ++this.indentLevel;
        this.visitNestedNode("initialize", forLoop.initialize(), forLoop);
        this.visitNestedNode("condition", forLoop.condition(), forLoop);
        this.visitNestedNode("update", forLoop.update(), forLoop);
        this.visitNestedNode("body", forLoop.body(), forLoop);
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    @Override
    public Void visitWhile(BytecodeNode parent, WhileLoop whileLoop) {
        if (whileLoop.getComment() != null) {
            this.printLine();
            this.printLine("// %s", whileLoop.getComment());
        }
        this.printLine("while {");
        ++this.indentLevel;
        this.visitNestedNode("condition", whileLoop.condition(), whileLoop);
        this.visitNestedNode("body", whileLoop.body(), whileLoop);
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    @Override
    public Void visitDoWhile(BytecodeNode parent, DoWhileLoop doWhileLoop) {
        if (doWhileLoop.getComment() != null) {
            this.printLine();
            this.printLine("// %s", doWhileLoop.getComment());
        }
        this.printLine("while {");
        ++this.indentLevel;
        this.visitNestedNode("body", doWhileLoop.body(), doWhileLoop);
        this.visitNestedNode("condition", doWhileLoop.condition(), doWhileLoop);
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    @Override
    public Void visitLookupSwitch(BytecodeNode parent, LookupSwitch lookupSwitch) {
        if (lookupSwitch.getComment() != null) {
            this.printLine();
            this.printLine("// %s", lookupSwitch.getComment());
        }
        this.printLine("switch {");
        ++this.indentLevel;
        for (CaseStatement caseStatement : lookupSwitch.getCases()) {
            this.printLine("case %s: goto %s", caseStatement.getKey(), caseStatement.getLabel().getName());
        }
        this.printLine("default: goto %s", lookupSwitch.getDefaultCase().getName());
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    @Override
    public Void visitInstruction(BytecodeNode parent, InstructionNode node) {
        return (Void)super.visitInstruction(parent, node);
    }

    @Override
    public Void visitBoxedBooleanConstant(BytecodeNode parent, Constant.BoxedBooleanConstant boxedBooleanConstant) {
        this.printLine("load constant %s", boxedBooleanConstant.getValue());
        return null;
    }

    @Override
    public Void visitBooleanConstant(BytecodeNode parent, Constant.BooleanConstant booleanConstant) {
        this.printLine("load constant %s", booleanConstant.getValue());
        return null;
    }

    @Override
    public Void visitIntConstant(BytecodeNode parent, Constant.IntConstant intConstant) {
        this.printLine("load constant %s", intConstant.getValue());
        return null;
    }

    @Override
    public Void visitBoxedIntegerConstant(BytecodeNode parent, Constant.BoxedIntegerConstant boxedIntegerConstant) {
        this.printLine("load constant new Integer(%s)", boxedIntegerConstant.getValue());
        return null;
    }

    @Override
    public Void visitFloatConstant(BytecodeNode parent, Constant.FloatConstant floatConstant) {
        this.printLine("load constant %sf", floatConstant.getValue());
        return null;
    }

    @Override
    public Void visitBoxedFloatConstant(BytecodeNode parent, Constant.BoxedFloatConstant boxedFloatConstant) {
        this.printLine("load constant new Float(%sf)", boxedFloatConstant.getValue());
        return null;
    }

    @Override
    public Void visitLongConstant(BytecodeNode parent, Constant.LongConstant longConstant) {
        this.printLine("load constant %sL", longConstant.getValue());
        return null;
    }

    @Override
    public Void visitBoxedLongConstant(BytecodeNode parent, Constant.BoxedLongConstant boxedLongConstant) {
        this.printLine("load constant new Long(%sL)", boxedLongConstant.getValue());
        return null;
    }

    @Override
    public Void visitDoubleConstant(BytecodeNode parent, Constant.DoubleConstant doubleConstant) {
        this.printLine("load constant %s", doubleConstant.getValue());
        return null;
    }

    @Override
    public Void visitBoxedDoubleConstant(BytecodeNode parent, Constant.BoxedDoubleConstant boxedDoubleConstant) {
        this.printLine("load constant new Double(%s)", boxedDoubleConstant.getValue());
        return null;
    }

    @Override
    public Void visitStringConstant(BytecodeNode parent, Constant.StringConstant stringConstant) {
        this.printLine("load constant \"%s\"", stringConstant.getValue());
        return null;
    }

    @Override
    public Void visitClassConstant(BytecodeNode parent, Constant.ClassConstant classConstant) {
        this.printLine("load constant %s.class", classConstant.getValue().getJavaClassName());
        return null;
    }

    @Override
    public Void visitLineNumber(BytecodeNode parent, LineNumberNode lineNumberNode) {
        this.lineNumber = lineNumberNode.getLineNumber();
        this.printLine("LINE %s", this.lineNumber);
        return null;
    }

    public void printLine() {
        this.out.println(this.indent(this.indentLevel));
    }

    public void printLine(String line) {
        this.out.println(String.format("%s%s", this.indent(this.indentLevel), line));
    }

    public void printLine(String format, Object ... args) {
        String line = String.format(format, args);
        this.out.println(String.format("%s%s", this.indent(this.indentLevel), line));
    }

    public void printWords(String ... words) {
        String line = Joiner.on((String)" ").join((Object[])words);
        this.out.println(String.format("%s%s", this.indent(this.indentLevel), line));
    }

    private String indent(int level) {
        return Strings.repeat((String)"    ", (int)level);
    }

    private void visitNestedNode(String description, BytecodeNode node, BytecodeNode parent) {
        this.printLine(description + " {");
        ++this.indentLevel;
        node.accept(parent, this);
        --this.indentLevel;
        this.printLine("}");
    }

    private Line line() {
        return new Line();
    }

    private Line line(String separator) {
        return new Line(separator);
    }

    private class Line {
        private final String separator;
        private final List<Object> parts = new ArrayList<Object>();

        private Line() {
            this.separator = " ";
        }

        private Line(String separator) {
            this.separator = separator;
        }

        public Line add(Object element) {
            this.parts.add(element);
            return this;
        }

        public Line addAll(Collection<?> c) {
            this.parts.addAll(c);
            return this;
        }

        public void print() {
            DumpBytecodeVisitor.this.printLine(Joiner.on((String)this.separator).join(this.parts));
        }

        public String toString() {
            return Joiner.on((String)this.separator).join(this.parts);
        }
    }
}

