/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.builtin.tools;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.builtin.tools.WorkerFunctionRegistryTool;
import com.facebook.presto.builtin.tools.WorkerFunctionUtil;
import com.facebook.presto.functionNamespace.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.functionNamespace.UdfFunctionSignatureMap;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.SqlFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NativeSidecarFunctionRegistryTool
implements WorkerFunctionRegistryTool {
    private final int maxRetries;
    private final long retryDelayMs;
    private static final Logger log = Logger.get(NativeSidecarFunctionRegistryTool.class);
    private final JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> nativeFunctionSignatureMapJsonCodec;
    private final NodeManager nodeManager;
    private final HttpClient httpClient;
    private static final String FUNCTION_SIGNATURES_ENDPOINT = "/v1/functions";

    public NativeSidecarFunctionRegistryTool(HttpClient httpClient, JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> nativeFunctionSignatureMapJsonCodec, NodeManager nodeManager, int nativeSidecarRegistryToolNumRetries, long nativeSidecarRegistryToolRetryDelayMs) {
        this.nativeFunctionSignatureMapJsonCodec = Objects.requireNonNull(nativeFunctionSignatureMapJsonCodec, "nativeFunctionSignatureMapJsonCodec is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.httpClient = Objects.requireNonNull(httpClient, "typeManager is null");
        this.maxRetries = nativeSidecarRegistryToolNumRetries;
        this.retryDelayMs = nativeSidecarRegistryToolRetryDelayMs;
    }

    @Override
    public List<? extends SqlFunction> getWorkerFunctions() {
        return (List)this.getNativeFunctionSignatureMap().getUDFSignatureMap().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(metaInfo -> WorkerFunctionUtil.createSqlInvokedFunction((String)entry.getKey(), metaInfo, "presto"))).collect(ImmutableList.toImmutableList());
    }

    private UdfFunctionSignatureMap getNativeFunctionSignatureMap() {
        try {
            Request request = Request.Builder.prepareGet().setUri(NativeSidecarFunctionRegistryTool.getSidecarLocationOnStartup(this.nodeManager, this.maxRetries, this.retryDelayMs)).build();
            Map nativeFunctionSignatureMap = (Map)this.httpClient.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.nativeFunctionSignatureMapJsonCodec));
            return new UdfFunctionSignatureMap((Map)ImmutableMap.copyOf((Map)nativeFunctionSignatureMap));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Failed to get functions from sidecar.", (Throwable)e);
        }
    }

    public static URI getSidecarLocationOnStartup(NodeManager nodeManager, int maxRetries, long retryDelayMs) {
        Node sidecarNode = null;
        for (int attempt = 1; attempt <= maxRetries; ++attempt) {
            try {
                sidecarNode = nodeManager.getSidecarNode();
                if (sidecarNode == null) continue;
                break;
            }
            catch (Exception e) {
                log.error("Error getting sidecar node (attempt " + attempt + "): " + e.getMessage());
                if (attempt == maxRetries) {
                    throw new RuntimeException("Failed to get sidecar node", e);
                }
                try {
                    Thread.sleep(retryDelayMs);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Retry fetching sidecar function registry interrupted", ie);
                }
            }
        }
        return HttpUriBuilder.uriBuilderFrom((URI)sidecarNode.getHttpUri()).appendPath(FUNCTION_SIGNATURES_ENDPOINT).build();
    }
}

