/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.plugin.bigquery.BigQueryClient;
import com.facebook.presto.plugin.bigquery.BigQueryErrorCode;
import com.facebook.presto.plugin.bigquery.BigQueryStorageClientFactory;
import com.facebook.presto.plugin.bigquery.BigQueryUtil;
import com.facebook.presto.plugin.bigquery.ReadSessionCreatorConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class ReadSessionCreator {
    private static final Logger log = Logger.get(ReadSessionCreator.class);
    private static Cache<String, TableInfo> destinationTableCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private final ReadSessionCreatorConfig config;
    private final BigQueryClient bigQueryClient;
    private final BigQueryStorageClientFactory bigQueryStorageClientFactory;

    public ReadSessionCreator(ReadSessionCreatorConfig config, BigQueryClient bigQueryClient, BigQueryStorageClientFactory bigQueryStorageClientFactory) {
        this.config = config;
        this.bigQueryClient = bigQueryClient;
        this.bigQueryStorageClientFactory = bigQueryStorageClientFactory;
    }

    public Storage.ReadSession create(TableId table, ImmutableList<String> selectedFields, Optional<String> filter, int parallelism) {
        TableInfo tableDetails = this.bigQueryClient.getTable(table);
        TableInfo actualTable = this.getActualTable(tableDetails, selectedFields, new String[0]);
        try (BigQueryStorageClient bigQueryStorageClient = this.bigQueryStorageClientFactory.createBigQueryStorageClient();){
            Storage.ReadSession readSession;
            ReadOptions.TableReadOptions.Builder readOptions = ReadOptions.TableReadOptions.newBuilder().addAllSelectedFields(selectedFields);
            filter.ifPresent(arg_0 -> ((ReadOptions.TableReadOptions.Builder)readOptions).setRowRestriction(arg_0));
            TableReferenceProto.TableReference tableReference = this.toTableReference(actualTable.getTableId());
            Storage.ReadSession readSession2 = readSession = bigQueryStorageClient.createReadSession(Storage.CreateReadSessionRequest.newBuilder().setParent("projects/" + this.bigQueryClient.getProjectId()).setFormat(Storage.DataFormat.AVRO).setRequestedStreams(parallelism).setReadOptions(readOptions).setTableReference(tableReference).setShardingStrategy(Storage.ShardingStrategy.BALANCED).build());
            return readSession2;
        }
    }

    TableReferenceProto.TableReference toTableReference(TableId tableId) {
        return TableReferenceProto.TableReference.newBuilder().setProjectId(tableId.getProject()).setDatasetId(tableId.getDataset()).setTableId(tableId.getTable()).build();
    }

    TableInfo getActualTable(TableInfo table, ImmutableList<String> requiredColumns, String[] filters) {
        TableDefinition tableDefinition = table.getDefinition();
        TableDefinition.Type tableType = tableDefinition.getType();
        if (TableDefinition.Type.TABLE == tableType) {
            return table;
        }
        if (TableDefinition.Type.VIEW == tableType) {
            if (!this.config.viewsEnabled) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Views are not enabled. You can enable views by setting 'bigquery.views-enabled' to true. Notice additional cost may occur.");
            }
            String querySql = this.bigQueryClient.createSql(table.getTableId(), (List<String>)requiredColumns);
            log.debug("querySql is %s", new Object[]{querySql});
            try {
                return (TableInfo)destinationTableCache.get((Object)querySql, (Callable)new DestinationTableBuilder(this.bigQueryClient, this.config, querySql, table.getTableId()));
            }
            catch (ExecutionException e) {
                throw new PrestoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_VIEW_DESTINATION_TABLE_CREATION_FAILED, "Error creating destination table", (Throwable)e);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Table type '%s' of table '%s.%s' is not supported", tableType, table.getTableId().getDataset(), table.getTableId().getTable()));
    }

    static class DestinationTableBuilder
    implements Callable<TableInfo> {
        final BigQueryClient bigQueryClient;
        final ReadSessionCreatorConfig config;
        final String querySql;
        final TableId table;

        DestinationTableBuilder(BigQueryClient bigQueryClient, ReadSessionCreatorConfig config, String querySql, TableId table) {
            this.bigQueryClient = bigQueryClient;
            this.config = config;
            this.querySql = querySql;
            this.table = table;
        }

        @Override
        public TableInfo call() {
            return this.createTableFromQuery();
        }

        TableInfo createTableFromQuery() {
            TableId destinationTable = this.bigQueryClient.createDestinationTable(this.table);
            log.debug("destinationTable is %s", new Object[]{destinationTable});
            JobInfo jobInfo = JobInfo.of((JobConfiguration)QueryJobConfiguration.newBuilder((String)this.querySql).setDestinationTable(destinationTable).build());
            log.debug("running query %s", new Object[]{jobInfo});
            Job job = this.waitForJob(this.bigQueryClient.create(jobInfo));
            log.debug("job has finished. %s", new Object[]{job});
            if (job.getStatus().getError() != null) {
                throw BigQueryUtil.convertToBigQueryException(job.getStatus().getError());
            }
            TableInfo createdTable = this.bigQueryClient.getTable(destinationTable);
            long expirationTime = createdTable.getCreationTime() + TimeUnit.HOURS.toMillis(this.config.viewExpirationTimeInHours);
            Table updatedTable = this.bigQueryClient.update(createdTable.toBuilder().setExpirationTime(Long.valueOf(expirationTime)).build());
            return updatedTable;
        }

        Job waitForJob(Job job) {
            try {
                return job.waitFor(new RetryOption[0]);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BigQueryException(0, String.format("Job %s has been interrupted", job.getJobId()), (Throwable)e);
            }
        }
    }
}

